/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.livy.LivyRestBuilder;
import org.apache.kylin.common.livy.LivyRestExecutor;
import org.apache.kylin.common.livy.LivyStateEnum;
import org.apache.kylin.common.livy.LivyTypeEnum;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.SparkCubingByLayer;
import org.apache.kylin.engine.spark.SparkExecutable;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExecutableLivy
extends SparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SparkExecutableLivy.class);
    private static final String CLASS_NAME = "className";
    private static final String JARS = "jars";
    private static final String JOB_ID = "jobId";
    private static final String COUNTER_SAVE_AS = "CounterSaveAs";
    private static final String CONFIG_NAME = "configName";

    public void formatArgs(List<String> args) {
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            if (!entry.getKey().equals(CLASS_NAME)) continue;
            args.add("-" + entry.getKey());
            args.add(entry.getValue());
            break;
        }
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            if (entry.getKey().equals(CLASS_NAME) || entry.getKey().equals(JARS) || entry.getKey().equals(JOB_ID) || entry.getKey().equals(COUNTER_SAVE_AS) || entry.getKey().equals(CONFIG_NAME)) continue;
            args.add("-" + entry.getKey());
            args.add(entry.getValue());
        }
    }

    @Override
    protected void onExecuteStart(ExecutableContext executableContext) {
        block6: {
            Output output = this.getOutput();
            if (output.getExtra().containsKey("startTime")) {
                String sparkJobID = output.getExtra().get("spark_job_id");
                if (sparkJobID == null) {
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                    return;
                }
                try {
                    String status = this.getAppState(sparkJobID);
                    if (Strings.isNullOrEmpty((String)status) || LivyStateEnum.dead.name().equalsIgnoreCase(status) || LivyStateEnum.error.name().equalsIgnoreCase(status) || LivyStateEnum.shutting_down.name().equalsIgnoreCase(status)) {
                        super.onExecuteStart(executableContext);
                        break block6;
                    }
                    this.getManager().updateJobOutput(this.getId(), ExecutableState.RUNNING, null, null);
                }
                catch (IOException e) {
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
            } else {
                super.onExecuteStart(executableContext);
            }
        }
    }

    @Override
    protected ExecuteResult onResumed(String appId, ExecutableManager mgr) throws ExecuteException {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            logger.info("livy spark_job_id:" + appId + " resumed");
            info.put("spark_job_id", appId);
            while (!this.isPaused() && !this.isDiscarded()) {
                String status = this.getAppState(appId);
                if (Strings.isNullOrEmpty((String)status) || LivyStateEnum.dead.name().equalsIgnoreCase(status) || LivyStateEnum.error.name().equalsIgnoreCase(status) || LivyStateEnum.shutting_down.name().equalsIgnoreCase(status)) {
                    mgr.updateJobOutput(this.getId(), ExecutableState.ERROR, null, appId + " has failed");
                    return new ExecuteResult(ExecuteResult.State.FAILED, appId + " has failed");
                }
                if (LivyStateEnum.success.name().equalsIgnoreCase(status)) {
                    mgr.addJobInfo(this.getId(), info);
                    return new ExecuteResult(ExecuteResult.State.SUCCEED, appId + " has finished");
                }
                Thread.sleep(5000L);
            }
            this.killAppRetry(appId);
            if (this.isDiscarded()) {
                return new ExecuteResult(ExecuteResult.State.DISCARDED, appId + " is discarded");
            }
            return new ExecuteResult(ExecuteResult.State.STOPPED, appId + " is stopped");
        }
        catch (Exception e) {
            logger.error("error run spark job:", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        ExecutableManager mgr = this.getManager();
        Map<String, String> extra = mgr.getOutput(this.getId()).getExtra();
        String sparkJobId = extra.get("spark_job_id");
        if (!StringUtils.isEmpty(sparkJobId)) {
            return this.onResumed(sparkJobId, mgr);
        }
        String cubeName = this.getParam(SparkCubingByLayer.OPTION_CUBE_NAME.getOpt());
        CubeInstance cube = CubeManager.getInstance(context.getConfig()).getCube(cubeName);
        KylinConfig config = cube.getConfig();
        this.setAlgorithmLayer();
        LivyRestBuilder livyRestBuilder = new LivyRestBuilder();
        String segmentID = this.getParam(SparkCubingByLayer.OPTION_SEGMENT_ID.getOpt());
        CubeSegment segment = cube.getSegmentById(segmentID);
        Segments<CubeSegment> mergingSeg = cube.getMergingSegments(segment);
        this.dumpMetadata(segment, mergingSeg);
        Map<String, String> sparkConfs = config.getSparkConfigOverride();
        String sparkConfigName = this.getSparkConfigName();
        if (sparkConfigName != null) {
            Map<String, String> sparkSpecificConfs = config.getSparkConfigOverrideWithSpecificName(sparkConfigName);
            sparkConfs.putAll(sparkSpecificConfs);
        }
        for (Map.Entry entry : sparkConfs.entrySet()) {
            if (((String)entry.getKey()).equals("spark.submit.deployMode") || ((String)entry.getKey()).equals("spark.master") || ((String)entry.getKey()).equals("spark.yarn.archive")) continue;
            livyRestBuilder.addConf((String)entry.getKey(), (String)entry.getValue());
        }
        this.formatArgs(livyRestBuilder.getArgs());
        LivyRestExecutor executor = new LivyRestExecutor();
        PatternedLogger patternedLogger = new PatternedLogger(logger, 4, (infoKey, info) -> {
            if ("spark_job_id".equals(infoKey) || "yarn_application_id".equals(infoKey) || "yarn_application_tracking_url".equals(infoKey)) {
                this.getManager().addJobInfo(this.getId(), info);
            }
        });
        try {
            livyRestBuilder.setLivyTypeEnum(LivyTypeEnum.job);
            executor.execute(livyRestBuilder, patternedLogger);
            if (this.isDiscarded()) {
                return new ExecuteResult(ExecuteResult.State.DISCARDED, "Discarded");
            }
            if (this.isPaused()) {
                return new ExecuteResult(ExecuteResult.State.STOPPED, "Stopped");
            }
            Map<String, String> joblogInfo = patternedLogger.getInfo();
            String counterOutput = this.getParam("counterOutput");
            if (counterOutput != null) {
                if (HadoopUtil.getWorkingFileSystem().exists(new Path(counterOutput))) {
                    Map<String, String> counterMap = HadoopUtil.readFromSequenceFile(counterOutput);
                    joblogInfo.putAll(counterMap);
                } else {
                    logger.warn("Spark counter output path not exists: " + counterOutput);
                }
            }
            this.readCounters(joblogInfo);
            this.getManager().addJobInfo(this.getId(), joblogInfo);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, patternedLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("error run spark job:", e);
            extra = mgr.getOutput(this.getId()).getExtra();
            extra.put("spark_job_id", "");
            this.getManager().addJobInfo(this.getId(), extra);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getMessage());
        }
    }

    @Override
    protected String getAppState(String appId) throws IOException {
        LivyRestExecutor executor = new LivyRestExecutor();
        return executor.state(appId);
    }

    @Override
    protected void killApp(String appId) throws IOException, InterruptedException {
        LivyRestExecutor executor = new LivyRestExecutor();
        executor.kill(appId);
    }

    @Override
    protected int killAppRetry(String appId) throws IOException, InterruptedException {
        String status = this.getAppState(appId);
        if (Strings.isNullOrEmpty((String)status) || LivyStateEnum.dead.name().equalsIgnoreCase(status) || LivyStateEnum.error.name().equalsIgnoreCase(status) || LivyStateEnum.shutting_down.name().equalsIgnoreCase(status)) {
            logger.warn(appId + "is final state, no need to kill");
            return 0;
        }
        this.killApp(appId);
        status = this.getAppState(appId);
        for (int retry = 0; Strings.isNullOrEmpty((String)status) || LivyStateEnum.dead.name().equalsIgnoreCase(status) || LivyStateEnum.error.name().equalsIgnoreCase(status) || LivyStateEnum.shutting_down.name().equalsIgnoreCase(status) && retry < 5; ++retry) {
            this.killApp(appId);
            Thread.sleep(1000L);
            status = this.getAppState(appId);
        }
        if (Strings.isNullOrEmpty((String)status)) {
            logger.info(appId + " killed successfully");
            return 0;
        }
        logger.info(appId + " killed failed");
        return 1;
    }
}

