/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ConstantTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.NoneTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class ExpressionColCollector
implements ExpressionVisitor {
    private final Set<TblColRef> filterColumns = Sets.newHashSet();
    private final Set<TblColRef> measureColumns = Sets.newHashSet();
    private boolean ifFCols = true;
    private boolean ifMCols = true;

    public static Set<TblColRef> collectColumns(TupleExpression tupleExpression) {
        Pair<Set<TblColRef>, Set<TblColRef>> pairRet = ExpressionColCollector.collectColumnsPair(tupleExpression);
        HashSet<TblColRef> ret = Sets.newHashSet();
        ret.addAll((Collection)pairRet.getFirst());
        ret.addAll((Collection)pairRet.getSecond());
        return ret;
    }

    public static Pair<Set<TblColRef>, Set<TblColRef>> collectColumnsPair(TupleExpression tupleExpression) {
        ExpressionColCollector collector = new ExpressionColCollector();
        tupleExpression.accept(collector);
        return new Pair<Set<TblColRef>, Set<TblColRef>>(collector.filterColumns, collector.measureColumns);
    }

    public static Set<TblColRef> collectFilterColumns(TupleExpression tupleExpression) {
        ExpressionColCollector collector = new ExpressionColCollector();
        collector.ifMCols = false;
        tupleExpression.accept(collector);
        return collector.filterColumns;
    }

    public static Set<TblColRef> collectMeasureColumns(TupleExpression tupleExpression) {
        ExpressionColCollector collector = new ExpressionColCollector();
        collector.ifFCols = false;
        tupleExpression.accept(collector);
        return collector.measureColumns;
    }

    private ExpressionColCollector() {
    }

    @Override
    public TupleExpression visitConstant(ConstantTupleExpression constExpr) {
        return constExpr;
    }

    @Override
    public TupleExpression visitColumn(ColumnTupleExpression colExpr) {
        if (this.ifMCols) {
            this.measureColumns.add(colExpr.getColumn());
        }
        return colExpr;
    }

    @Override
    public TupleExpression visitBinary(BinaryTupleExpression binaryExpr) {
        binaryExpr.getLeft().accept(this);
        binaryExpr.getRight().accept(this);
        return binaryExpr;
    }

    @Override
    public TupleExpression visitCaseCall(CaseTupleExpression caseExpr) {
        for (Pair<TupleFilter, TupleExpression> entry : caseExpr.getWhenList()) {
            TupleFilter filter = entry.getFirst();
            if (this.ifFCols) {
                TupleFilter.collectColumns(filter, this.filterColumns);
            }
            entry.getSecond().accept(this);
        }
        if (caseExpr.getElseExpr() != null) {
            caseExpr.getElseExpr().accept(this);
        }
        return caseExpr;
    }

    @Override
    public TupleExpression visitRexCall(RexCallTupleExpression rexCallExpr) {
        for (TupleExpression tupleExpression : rexCallExpr.getChildren()) {
            tupleExpression.accept(this);
        }
        return rexCallExpr;
    }

    @Override
    public TupleExpression visitNone(NoneTupleExpression noneExpr) {
        return noneExpr;
    }
}

