/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.springacl;

import java.io.Serializable;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.util.Assert;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ObjectIdentityImpl
implements ObjectIdentity {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="id")
    private String identifier;

    public ObjectIdentityImpl() {
    }

    public ObjectIdentityImpl(ObjectIdentity oid) {
        this(oid.getType(), String.valueOf(oid.getIdentifier()));
    }

    public ObjectIdentityImpl(String type, String identifier) {
        Assert.hasText(type, "Type required");
        Assert.notNull(identifier, "identifier required");
        this.identifier = identifier;
        this.type = type;
    }

    public ObjectIdentityImpl(AclEntity ae) {
        Assert.notNull(ae, "ACL entity required");
        this.type = ae.getClass().getName();
        this.identifier = ae.getId();
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof ObjectIdentity)) {
            return false;
        }
        ObjectIdentity other = (ObjectIdentity)arg0;
        if (!this.identifier.equals(other.getIdentifier())) {
            return false;
        }
        return this.type.equals(other.getType());
    }

    @Override
    public Serializable getIdentifier() {
        return this.identifier;
    }

    public String getId() {
        return this.identifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int code = 31;
        code ^= this.type.hashCode();
        return code ^= this.identifier.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Type: ").append(this.type);
        sb.append("; Identifier: ").append(this.identifier).append("]");
        return sb.toString();
    }
}

