/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidCLI;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.CubeJobLockUtil;
import org.apache.kylin.engine.mr.common.CuboidRecommenderUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.metrics.property.QueryCubePropertyEnum;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.request.MetricsRequest;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.response.CubeInstanceResponse;
import org.apache.kylin.rest.response.CuboidTreeResponse;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.HybridService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.QueryService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ValidateUtil;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.StorageCleanUtil;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.stream.coordinator.StreamMetadataStoreFactory;
import org.apache.kylin.stream.coordinator.client.CoordinatorClient;
import org.apache.kylin.stream.coordinator.client.CoordinatorClientFactory;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="cubeMgmtService")
public class CubeService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CubeService.class);
    protected Cache<String, HBaseResponse> htableInfoCache = CacheBuilder.newBuilder().build();
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="queryService")
    private QueryService queryService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private HybridService hybridService;

    public boolean isCubeNameVaildate(String cubeName) {
        if (StringUtils.isEmpty(cubeName) || !ValidateUtil.isAlphanumericUnderscore(cubeName)) {
            return false;
        }
        for (CubeInstance cubeInstance : this.getCubeManager().listAllCubes()) {
            if (!cubeName.equalsIgnoreCase(cubeInstance.getName())) continue;
            return false;
        }
        return true;
    }

    public List<CubeInstance> listAllCubes(String cubeName, String projectName, String modelName, boolean exactMatch) {
        List<CubeInstance> cubeInstances = null;
        if (null == projectName) {
            cubeInstances = this.getCubeManager().listAllCubes();
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            cubeInstances = this.listAllCubes(projectName);
            this.aclEvaluate.checkProjectReadPermission(projectName);
        }
        List<Object> filterModelCubes = new ArrayList();
        if (modelName != null) {
            for (CubeInstance cubeInstance : cubeInstances) {
                boolean bl = cubeInstance.getDescriptor().getModelName().equalsIgnoreCase(modelName);
                if (!bl) continue;
                filterModelCubes.add(0, cubeInstance);
            }
        } else {
            filterModelCubes = cubeInstances;
        }
        ArrayList<CubeInstance> filterCubes = new ArrayList<CubeInstance>();
        for (CubeInstance cubeInstance : filterModelCubes) {
            boolean isCubeMatch = null == cubeName || !exactMatch && cubeInstance.getName().toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT)) || exactMatch && cubeInstance.getName().toLowerCase(Locale.ROOT).equals(cubeName.toLowerCase(Locale.ROOT));
            if (!isCubeMatch) continue;
            filterCubes.add(cubeInstance);
        }
        filterCubes.sort((o1, o2) -> Long.compare(o2.getCreateTimeUTC(), o1.getCreateTimeUTC()));
        return filterCubes;
    }

    public CubeInstance updateCubeCost(CubeInstance cube, int cost) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        if (cube.getCost() == cost) {
            return cube;
        }
        cube.setCost(cost);
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        cube.setOwner(owner);
        CubeUpdate update = new CubeUpdate(cube.latestCopyForWrite()).setOwner(owner).setCost(cost);
        return this.getCubeManager().updateCube(update);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeInstance createCubeAndDesc(ProjectInstance project, CubeDesc desc) throws IOException {
        Message msg = MsgPicker.getMsg();
        String cubeName = desc.getName();
        if (this.getCubeManager().getCube(cubeName) != null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getCUBE_ALREADY_EXIST(), cubeName));
        }
        if (this.getCubeDescManager().getCubeDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getCUBE_DESC_ALREADY_EXIST(), desc.getName()));
        }
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        CubeDesc createdDesc = this.getCubeDescManager().createCubeDesc(desc);
        if (createdDesc.isBroken()) {
            throw new BadRequestException(createdDesc.getErrorsAsString());
        }
        int cuboidCount = CuboidCLI.simulateCuboidGeneration(createdDesc, false);
        logger.info("New cube " + cubeName + " has " + cuboidCount + " cuboids");
        CubeInstance createdCube = this.getCubeManager().createCube(cubeName, project.getName(), createdDesc, owner);
        return createdCube;
    }

    public List<CubeInstance> listAllCubes(String projectName) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube != null) {
                result.add(cube);
                continue;
            }
            logger.error("Cube instance " + projectDataModel.getRealization() + " is failed to load");
        }
        return result;
    }

    protected boolean isCubeInProject(String projectName, CubeInstance target) {
        ProjectManager projectManager = this.getProjectManager();
        ProjectInstance project = projectManager.getProject(projectName);
        if (project == null) {
            return false;
        }
        for (RealizationEntry projectDataModel : project.getRealizationEntries()) {
            if (projectDataModel.getType() != RealizationType.CUBE) continue;
            CubeInstance cube = this.getCubeManager().getCube(projectDataModel.getRealization());
            if (cube == null) {
                logger.error("Project " + projectName + " contains realization " + projectDataModel.getRealization() + " which is not found by CubeManager");
                continue;
            }
            if (!cube.equals(target)) continue;
            return true;
        }
        return false;
    }

    public CubeDesc updateCubeAndDesc(CubeInstance cube, CubeDesc desc, String newProjectName, boolean forceUpdate) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        if (!forceUpdate && !cube.getDescriptor().consistentWith(desc)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
        }
        CubeDesc updatedCubeDesc = this.getCubeDescManager().updateCubeDesc(desc);
        int cuboidCount = CuboidCLI.simulateCuboidGeneration(updatedCubeDesc, false);
        logger.info("Updated cube " + cube.getName() + " has " + cuboidCount + " cuboids");
        ProjectManager projectManager = this.getProjectManager();
        if (!this.isCubeInProject(newProjectName, cube)) {
            String owner = SecurityContextHolder.getContext().getAuthentication().getName();
            ProjectInstance projectInstance = projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), newProjectName, owner);
        }
        return updatedCubeDesc;
    }

    public void deleteCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDISCARD_JOB_FIRST(), cube.getName()));
        }
        try {
            this.releaseAllJobs(cube);
        }
        catch (Exception e) {
            logger.error("error when releasing all jobs", e);
        }
        ProjectInstance projectInstance = cube.getProjectInstance();
        List<RealizationEntry> hybridRealizationEntries = projectInstance.getRealizationEntries(RealizationType.HYBRID);
        if (hybridRealizationEntries != null) {
            for (RealizationEntry entry : hybridRealizationEntries) {
                HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                List<RealizationEntry> cubeRealizationEntries = instance.getRealizationEntries();
                boolean needUpdateHybrid = false;
                for (RealizationEntry cubeRealizationEntry : cubeRealizationEntries) {
                    if (!cube.getName().equals(cubeRealizationEntry.getRealization())) continue;
                    needUpdateHybrid = true;
                    cubeRealizationEntries.remove(cubeRealizationEntry);
                    break;
                }
                if (!needUpdateHybrid) continue;
                String[] cubeNames = new String[cubeRealizationEntries.size()];
                for (int i = 0; i < cubeRealizationEntries.size(); ++i) {
                    cubeNames[i] = cubeRealizationEntries.get(i).getRealization();
                }
                this.hybridService.updateHybridCubeNoCheck(instance.getName(), projectInstance.getName(), cube.getModel().getName(), cubeNames);
            }
        }
        Segments<CubeSegment> toRemoveSegs = cube.getSegments();
        int cubeNum = this.getCubeManager().getCubesByDesc(cube.getDescriptor().getName()).size();
        this.getCubeManager().dropCube(cube.getName(), cubeNum == 1);
        this.cleanSegmentStorage(toRemoveSegs);
    }

    public void deleteCubeFast(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        int cubeNum = this.getCubeManager().getCubesByDesc(cube.getDescriptor().getName()).size();
        this.getCubeManager().dropCube(cube.getName(), cubeNum == 1);
    }

    public CubeInstance purgeCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cubeName, null, EnumSet.of(ExecutableState.READY, ExecutableState.RUNNING, ExecutableState.ERROR, ExecutableState.STOPPED));
        if (!cubingJobs.isEmpty()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDISCARD_JOB_FIRST(), cubeName));
        }
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.DISABLED.equals(ostatus)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getPURGE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        this.releaseAllSegments(cube);
        return cube;
    }

    public CubeInstance disableCube(CubeInstance cube) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (null != ostatus && !RealizationStatusEnum.READY.equals(ostatus)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDISABLE_NOT_READY_CUBE(), cubeName, ostatus));
        }
        boolean isStreamingCube = cube.getDescriptor().isStreamingCube();
        boolean cubeStatusUpdated = false;
        try {
            CubeInstance cubeInstance = this.getCubeManager().updateCubeStatus(cube, RealizationStatusEnum.DISABLED);
            cubeStatusUpdated = true;
            if (isStreamingCube) {
                CubeSegment[] buildingSegments = new CubeSegment[cubeInstance.getBuildingSegments().size()];
                Segments<CubeSegment> segments = cubeInstance.getBuildingSegments();
                if (!CollectionUtils.isEmpty(segments)) {
                    for (int i = 0; i < segments.size(); ++i) {
                        buildingSegments[i] = (CubeSegment)segments.get(i);
                    }
                    this.getCubeManager().dropOptmizingSegments(cubeInstance, buildingSegments);
                }
                this.getStreamingCoordinator().unAssignCube(cubeName);
                this.releaseAllJobs(cubeInstance);
            }
            return cubeInstance;
        }
        catch (Exception e) {
            cube.setStatus(ostatus);
            if (cubeStatusUpdated) {
                logger.info("roll back cube status to:{}", (Object)ostatus);
                this.getCubeManager().updateCubeStatus(cube, ostatus);
            }
            throw e;
        }
    }

    public void checkEnableCubeCondition(CubeInstance cube) {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String cubeName = cube.getName();
        RealizationStatusEnum ostatus = cube.getStatus();
        if (!cube.getStatus().equals(RealizationStatusEnum.DISABLED)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getENABLE_NOT_DISABLED_CUBE(), cubeName, ostatus));
        }
        if (cube.getSegments(SegmentStatusEnum.READY).size() == 0 && !cube.getDescriptor().isStreamingCube()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getNO_READY_SEGMENT(), cubeName));
        }
        if (!cube.getDescriptor().checkSignature()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getINCONSISTENT_CUBE_DESC_SIGNATURE(), cube.getDescriptor()));
        }
    }

    public CubeInstance enableCube(CubeInstance cube) throws IOException {
        boolean cubeStatusUpdated = false;
        RealizationStatusEnum ostatus = cube.getStatus();
        try {
            CubeInstance cubeInstance = this.getCubeManager().updateCubeStatus(cube, RealizationStatusEnum.READY);
            cubeStatusUpdated = true;
            if (cube.getDescriptor().isStreamingCube()) {
                this.getStreamingCoordinator().assignCube(cube.getName());
            }
            return cubeInstance;
        }
        catch (Exception e) {
            cube.setStatus(ostatus);
            if (cubeStatusUpdated) {
                logger.info("roll back cube status to:{}", (Object)ostatus);
                this.getCubeManager().updateCubeStatus(cube, ostatus);
            }
            throw e;
        }
    }

    private CoordinatorClient getStreamingCoordinator() {
        return CoordinatorClientFactory.createCoordinatorClient(StreamMetadataStoreFactory.getStreamMetaDataStore());
    }

    public MetricsResponse calculateMetrics(MetricsRequest request) {
        List<CubeInstance> cubes = this.getCubeManager().listAllCubes();
        MetricsResponse metrics = new MetricsResponse();
        Date startTime = null == request.getStartTime() ? new Date(-1L) : request.getStartTime();
        Date endTime = null == request.getEndTime() ? new Date() : request.getEndTime();
        metrics.increase("totalCubes", Float.valueOf(0.0f));
        metrics.increase("totalStorage", Float.valueOf(0.0f));
        for (CubeInstance cube : cubes) {
            Date createdDate = new Date(-1L);
            createdDate = cube.getCreateTimeUTC() == 0L ? createdDate : new Date(cube.getCreateTimeUTC());
            if (createdDate.getTime() <= startTime.getTime() || createdDate.getTime() >= endTime.getTime()) continue;
            metrics.increase("totalCubes");
        }
        metrics.increase("aveStorage", Float.valueOf(((Float)metrics.get("totalCubes")).floatValue() == 0.0f ? 0.0f : ((Float)metrics.get("totalStorage")).floatValue() / ((Float)metrics.get("totalCubes")).floatValue()));
        return metrics;
    }

    public HBaseResponse getHTableInfo(String cubeName, String tableName) throws IOException {
        String key = cubeName + "/" + tableName;
        HBaseResponse hr = this.htableInfoCache.getIfPresent(key);
        if (null != hr) {
            return hr;
        }
        hr = new HBaseResponse();
        CubeInstance cube = CubeManager.getInstance(this.getConfig()).getCube(cubeName);
        if (cube.getStorageType() == 0 || cube.getStorageType() == 2 || cube.getStorageType() == 3) {
            try {
                logger.debug("Loading HTable info " + cubeName + ", " + tableName);
                hr = (HBaseResponse)Class.forName("org.apache.kylin.rest.service.HBaseInfoUtil").getMethod("getHBaseInfo", String.class, KylinConfig.class).invoke(null, tableName, this.getConfig());
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        this.htableInfoCache.put(key, hr);
        return hr;
    }

    public void updateCubeNotifyList(CubeInstance cube, List<String> notifyList) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        CubeDesc desc = cube.getDescriptor();
        desc.setNotifyList(notifyList);
        this.getCubeDescManager().updateCubeDesc(desc);
    }

    public CubeInstance updateCubeOwner(CubeInstance cube, String owner) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        if (Objects.equals(cube.getOwner(), owner)) {
            return cube;
        }
        cube.setOwner(owner);
        CubeUpdate update = new CubeUpdate(cube.latestCopyForWrite()).setOwner(owner);
        return this.getCubeManager().updateCube(update);
    }

    public CubeInstance rebuildLookupSnapshot(CubeInstance cube, String segmentName, String lookupTable) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        TableDesc tableDesc = this.getTableManager().getTableDesc(lookupTable, cube.getProject());
        if (tableDesc.isView()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getREBUILD_SNAPSHOT_OF_VIEW(), tableDesc.getName()));
        }
        CubeSegment seg = cube.getSegment(segmentName, SegmentStatusEnum.READY);
        this.getCubeManager().buildSnapshotTable(seg, lookupTable, null);
        return cube;
    }

    public CubeInstance deleteSegmentById(CubeInstance cube, String uuid) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        CubeSegment toDelete = null;
        toDelete = cube.getSegmentById(uuid);
        if (toDelete == null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getSEG_NOT_FOUND(), uuid));
        }
        if (cube.getStatus() == RealizationStatusEnum.DISABLED || this.isOrphonSegment(cube, uuid)) {
            CubeInstance cubeInstance = CubeManager.getInstance(this.getConfig()).updateCubeDropSegments(cube, toDelete);
            this.cleanSegmentStorage(Collections.singletonList(toDelete));
            return cubeInstance;
        }
        throw new BadRequestException(String.format(Locale.ROOT, msg.getDELETE_READY_SEG_BY_UUID(), uuid, cube.getName()));
    }

    public CubeInstance deleteSegment(CubeInstance cube, String segmentName) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        Message msg = MsgPicker.getMsg();
        if (cube.getStatus() == RealizationStatusEnum.READY) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDELETE_SEG_FROM_READY_CUBE(), segmentName, cube.getName()));
        }
        CubeSegment toDelete = null;
        for (CubeSegment seg : cube.getSegments()) {
            if (!seg.getName().equals(segmentName)) continue;
            toDelete = seg;
            break;
        }
        if (toDelete == null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getSEG_NOT_FOUND(), segmentName));
        }
        if (toDelete.getStatus() != SegmentStatusEnum.READY) {
            if (toDelete.getStatus() == SegmentStatusEnum.NEW) {
                if (!this.isOrphonSegment(cube, toDelete.getUuid())) {
                    throw new BadRequestException(String.format(Locale.ROOT, msg.getDELETE_NOT_READY_SEG(), segmentName));
                }
            } else {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getDELETE_NOT_READY_SEG(), segmentName));
            }
        }
        if (!segmentName.equals(((CubeSegment)cube.getSegments().get(0)).getName()) && !segmentName.equals(((CubeSegment)cube.getSegments().get(cube.getSegments().size() - 1)).getName())) {
            logger.warn(String.format(Locale.ROOT, msg.getDELETE_SEGMENT_CAUSE_GAPS(), cube.getName(), segmentName));
        }
        CubeInstance cubeInstance = CubeManager.getInstance(this.getConfig()).updateCubeDropSegments(cube, toDelete);
        this.cleanSegmentStorage(Collections.singletonList(toDelete));
        return cubeInstance;
    }

    private void cleanSegmentStorage(List<CubeSegment> toRemoveSegs) throws IOException {
        if (!KylinConfig.getInstanceFromEnv().cleanStorageAfterDelOperation()) {
            return;
        }
        if (toRemoveSegs != null && !toRemoveSegs.isEmpty()) {
            ArrayList<String> toDropHTables = Lists.newArrayListWithCapacity(toRemoveSegs.size());
            ArrayList<String> toDelHDFSPaths = Lists.newArrayListWithCapacity(toRemoveSegs.size());
            for (CubeSegment seg : toRemoveSegs) {
                toDropHTables.add(seg.getStorageLocationIdentifier());
                toDelHDFSPaths.add(JobBuilderSupport.getJobWorkingDir(seg.getConfig().getHdfsWorkingDirectory(), seg.getLastBuildJobID()));
            }
            StorageCleanUtil.dropHTables(new HBaseAdmin(HBaseConnection.getCurrentHBaseConfiguration()), toDropHTables);
            StorageCleanUtil.deleteHDFSPath(HadoopUtil.getWorkingFileSystem(), toDelHDFSPaths);
        }
    }

    public boolean isOrphonSegment(CubeInstance cube, String segId) {
        List<JobInstance> jobInstances = this.jobService.searchJobsByCubeName(cube.getName(), cube.getProject(), Lists.newArrayList(JobStatusEnum.NEW, JobStatusEnum.PENDING, JobStatusEnum.RUNNING, JobStatusEnum.ERROR, JobStatusEnum.STOPPED), JobTimeFilterEnum.ALL, JobService.JobSearchMode.CUBING_ONLY);
        for (JobInstance jobInstance : jobInstances) {
            if (!segId.equals(jobInstance.getRelatedSegment())) continue;
            return false;
        }
        return true;
    }

    protected void releaseAllJobs(CubeInstance cube) {
        List<CubingJob> cubingJobs = this.jobService.listJobsByRealizationName(cube.getName(), null);
        for (CubingJob cubingJob : cubingJobs) {
            ExecutableState status = cubingJob.getStatus();
            if (status == ExecutableState.SUCCEED || status == ExecutableState.DISCARDED) continue;
            this.getExecutableManager().discardJob(cubingJob.getId());
            DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
            if (!lock.isLocked(CubeJobLockUtil.getLockPath(cube.getName(), cubingJob.getId()))) continue;
            lock.purgeLocks(CubeJobLockUtil.getLockPath(cube.getName(), null));
            logger.info("{} unlock cube job global lock path({}) success", (Object)cubingJob.getId(), (Object)CubeJobLockUtil.getLockPath(cube.getName(), null));
            if (!lock.isLocked(CubeJobLockUtil.getEphemeralLockPath(cube.getName()))) continue;
            lock.purgeLocks(CubeJobLockUtil.getEphemeralLockPath(cube.getName()));
            logger.info("{} unlock cube job ephemeral lock path({}) success", (Object)cubingJob.getId(), (Object)CubeJobLockUtil.getEphemeralLockPath(cube.getName()));
        }
    }

    private void releaseAllSegments(CubeInstance cube) throws IOException {
        this.releaseAllJobs(cube);
        Segments<CubeSegment> toRemoveSegs = cube.getSegments();
        this.getCubeManager().clearSegments(cube);
        this.cleanSegmentStorage(toRemoveSegs);
    }

    public void updateOnNewSegmentReady(String cubeName) {
        CubeSegment seg;
        CubeInstance cube;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String serverMode = kylinConfig.getServerMode();
        if (("job".equals(serverMode.toLowerCase(Locale.ROOT)) || "all".equals(serverMode.toLowerCase(Locale.ROOT))) && (cube = this.getCubeManager().getCube(cubeName)) != null && (seg = cube.getLatestBuiltSegment()) != null && seg.getStatus() == SegmentStatusEnum.READY) {
            this.keepCubeRetention(cubeName);
            this.mergeCubeSegment(cubeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepCubeRetention(String cubeName) {
        logger.info("checking keepCubeRetention");
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        CubeDesc desc = cube.getDescriptor();
        if (desc.getRetentionRange() <= 0L) {
            return;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            cube = this.getCubeManager().getCube(cubeName);
            Segments<CubeSegment> readySegs = cube.getSegments(SegmentStatusEnum.READY);
            if (readySegs.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            ArrayList<CubeSegment> toRemoveSegs = Lists.newArrayList();
            long tail = (Long)((CubeSegment)readySegs.get((int)(readySegs.size() - 1))).getTSRange().end.v;
            long head = tail - desc.getRetentionRange();
            for (CubeSegment seg : readySegs) {
                if ((Long)seg.getTSRange().end.v <= 0L || (Long)seg.getTSRange().end.v > head) continue;
                toRemoveSegs.add(seg);
            }
            if (toRemoveSegs.size() > 0) {
                try {
                    this.getCubeManager().updateCubeDropSegments(cube, toRemoveSegs);
                }
                catch (IOException e) {
                    logger.error("Failed to remove old segment from cube " + cubeName, e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mergeCubeSegment(String cubeName) {
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        if (!cube.needAutoMerge()) {
            return null;
        }
        if (!cube.isReady()) {
            logger.info("The cube: {} is disabled", (Object)cubeName);
            return null;
        }
        Class<CubeService> clazz = CubeService.class;
        synchronized (CubeService.class) {
            try {
                cube = this.getCubeManager().getCube(cubeName);
                SegmentRange offsets = cube.autoMergeCubeSegments();
                if (offsets != null && !this.isMergingJobBeenDiscarded(cube, cubeName, cube.getProject(), offsets)) {
                    CubeSegment newSeg = this.getCubeManager().mergeSegments(cube, null, offsets, true);
                    logger.info("Will submit merge job on " + newSeg);
                    DefaultChainedExecutable job = EngineFactory.createBatchMergeJob(newSeg, "SYSTEM");
                    this.getExecutableManager().addJob(job);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return job.getId();
                }
                logger.info("Not ready for merge on cube " + cubeName);
            }
            catch (IOException e) {
                logger.error("Failed to auto merge cube " + cubeName, e);
            }
            return null;
        }
    }

    private boolean isMergingJobBeenDiscarded(CubeInstance cubeInstance, String cubeName, String projectName, SegmentRange offsets) {
        SegmentRange.TSRange tsRange = new SegmentRange.TSRange((Long)offsets.start.v, (Long)offsets.end.v);
        String segmentName = CubeSegment.makeSegmentName(tsRange, null, cubeInstance.getModel());
        List<CubingJob> jobInstanceList = this.jobService.listJobsByRealizationName(cubeName, projectName, EnumSet.of(ExecutableState.DISCARDED));
        for (CubingJob cubingJob : jobInstanceList) {
            if (!segmentName.equals(cubingJob.getSegmentName())) continue;
            logger.debug("Merge job {} has been discarded before, will not merge.", (Object)segmentName);
            return true;
        }
        return false;
    }

    public void validateCubeDesc(CubeDesc desc, boolean isDraft) {
        Message msg = MsgPicker.getMsg();
        if (desc == null) {
            throw new BadRequestException(msg.getINVALID_CUBE_DEFINITION());
        }
        String cubeName = desc.getName();
        if (StringUtils.isEmpty(cubeName)) {
            logger.info("Cube name should not be empty.");
            throw new BadRequestException(msg.getEMPTY_CUBE_NAME());
        }
        if (!ValidateUtil.isAlphanumericUnderscore(cubeName)) {
            logger.info("Invalid Cube name {}, only letters, numbers and underscore supported.", (Object)cubeName);
            throw new BadRequestException(String.format(Locale.ROOT, msg.getINVALID_CUBE_NAME(), cubeName));
        }
        if (!isDraft) {
            DataModelDesc modelDesc = this.modelService.getDataModelManager().getDataModelDesc(desc.getModelName());
            if (modelDesc == null) {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getMODEL_NOT_FOUND(), desc.getModelName()));
            }
            if (modelDesc.isDraft()) {
                logger.info("Cannot use draft model.");
                throw new BadRequestException(String.format(Locale.ROOT, msg.getUSE_DRAFT_MODEL(), desc.getModelName()));
            }
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeDesc saveCube(CubeDesc desc, ProjectInstance project) throws IOException {
        Message msg = MsgPicker.getMsg();
        desc.setDraft(false);
        if (desc.getUuid() == null) {
            desc.updateRandomUuid();
        }
        try {
            this.createCubeAndDesc(project, desc);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (desc.isBroken()) {
            throw new BadRequestException(desc.getErrorsAsString());
        }
        return desc;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, CubeInstance cube, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public void saveDraft(ProjectInstance project, String uuid, RootPersistentEntity ... entities) throws IOException {
        Draft draft = new Draft();
        draft.setProject(project.getName());
        draft.setUuid(uuid);
        draft.setEntities(entities);
        this.getDraftManager().save(draft);
    }

    public void deleteDraft(Draft draft) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(draft.getProject());
        this.getDraftManager().delete(draft.getUuid());
    }

    public CubeDesc updateCube(CubeInstance cube, CubeDesc desc, ProjectInstance project) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(cube);
        Message msg = MsgPicker.getMsg();
        String projectName = project.getName();
        desc.setDraft(false);
        try {
            if (cube.getSegments().size() != 0 && !cube.getDescriptor().consistentWith(desc)) {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getINCONSISTENT_CUBE_DESC(), desc.getName()));
            }
            desc = this.updateCubeAndDesc(cube, desc, projectName, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_CUBE_NO_RIGHT());
        }
        if (desc.isBroken()) {
            throw new BadRequestException(desc.getErrorsAsString());
        }
        return desc;
    }

    public Draft getCubeDraft(String cubeName, String projectName) throws IOException {
        Iterator<Draft> iterator = this.listCubeDrafts(cubeName, null, projectName, true).iterator();
        if (iterator.hasNext()) {
            Draft d = iterator.next();
            return d;
        }
        return null;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION') or hasPermission(#project, 'MANAGEMENT')")
    public CubeInstance changeLookupSnapshotBeGlobal(CubeInstance cube, String lookupTable) throws BadRequestException {
        block8: {
            this.aclEvaluate.checkProjectWritePermission(cube.getProject());
            Message msg = MsgPicker.getMsg();
            CubeDesc cubeDesc = cube.getDescriptor();
            TableDesc tableDesc = this.getTableManager().getTableDesc(lookupTable, cube.getProject());
            if (tableDesc == null) {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getTABLE_DESC_NOT_FOUND(), lookupTable));
            }
            Set<String> inMemLookupTables = cubeDesc.getInMemLookupTables();
            if (!inMemLookupTables.contains(lookupTable)) {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getTABLE_DESC_NOT_FOUND(), lookupTable));
            }
            if (cubeDesc.isGlobalSnapshotTable(lookupTable)) {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getSNAPSHOT_GLOBAL(), tableDesc.getName()));
            }
            try {
                RealizationStatusEnum ostatus = cube.getStatus();
                if (null == ostatus || !cube.getStatus().equals(RealizationStatusEnum.DISABLED)) {
                    throw new BadRequestException(String.format(Locale.ROOT, msg.getENABLE_NOT_DISABLED_CUBE(), cube.getName(), ostatus));
                }
                int segmentsCount = cube.getSegments().size();
                if (segmentsCount == 0) {
                    this.getCubeDescManager().updatelookupTableSnapshotGlobal(cubeDesc, lookupTable, true);
                    break block8;
                }
                if (cube.getSegments(SegmentStatusEnum.READY).size() == segmentsCount) {
                    this.getCubeManager().updateCubeToBeGlobal(cube, lookupTable);
                    this.getCubeDescManager().updatelookupTableSnapshotGlobal(cubeDesc, lookupTable, true);
                    break block8;
                }
                throw new BadRequestException(String.format(Locale.ROOT, msg.getCUBE_HAS_NOT_READY_SEGS(), cube.getName()));
            }
            catch (IOException e) {
                logger.error("Failed to auto update snapshot be global " + cube.getName() + "@" + lookupTable, e);
            }
        }
        return cube;
    }

    public List<Draft> listCubeDrafts(String cubeName, String modelName, String project, boolean exactMatch) throws IOException {
        if (null == project) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectReadPermission(project);
        }
        ArrayList<Draft> result = new ArrayList<Draft>();
        for (Draft d : this.getDraftManager().list(project)) {
            RootPersistentEntity e = d.getEntity();
            if (!(e instanceof CubeDesc)) continue;
            CubeDesc c = (CubeDesc)e;
            if (cubeName != null && (!exactMatch || !cubeName.toLowerCase(Locale.ROOT).equals(c.getName().toLowerCase(Locale.ROOT))) && (exactMatch || !c.getName().toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT))) || modelName != null && !modelName.toLowerCase(Locale.ROOT).equals(c.getModelName().toLowerCase(Locale.ROOT))) continue;
            if (c.getMeasures() != null) {
                for (MeasureDesc m : c.getMeasures()) {
                    FunctionDesc f = m.getFunction();
                    if (!f.getExpression().equals("PERCENTILE")) continue;
                    f.setExpression("PERCENTILE_APPROX");
                }
            }
            result.add(d);
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        Broadcaster.getInstance(this.getConfig()).registerStaticListener(new HTableInfoSyncListener(), "cube");
    }

    public CubeInstanceResponse createCubeInstanceResponse(CubeInstance cube) {
        return new CubeInstanceResponse(cube, this.projectService.getProjectOfCube(cube.getName()));
    }

    public CuboidTreeResponse getCuboidTreeResponse(CuboidScheduler cuboidScheduler, Map<Long, Long> rowCountMap, Map<Long, Long> hitFrequencyMap, Map<Long, Long> queryMatchMap, Set<Long> currentCuboidSet) {
        long baseCuboidId = cuboidScheduler.getBaseCuboidId();
        int dimensionCount = Long.bitCount(baseCuboidId);
        long cubeQueryCount = 0L;
        if (hitFrequencyMap != null) {
            for (long queryCount : hitFrequencyMap.values()) {
                cubeQueryCount += queryCount;
            }
        }
        CuboidTreeResponse.NodeInfo root = this.generateNodeInfo(baseCuboidId, dimensionCount, cubeQueryCount, rowCountMap, hitFrequencyMap, queryMatchMap, currentCuboidSet);
        LinkedList<CuboidTreeResponse.NodeInfo> nodeQueue = Lists.newLinkedList();
        nodeQueue.add(root);
        while (!nodeQueue.isEmpty()) {
            CuboidTreeResponse.NodeInfo parentNode = (CuboidTreeResponse.NodeInfo)nodeQueue.remove(0);
            for (long childId : cuboidScheduler.getSpanningCuboid(parentNode.getId())) {
                CuboidTreeResponse.NodeInfo childNode = this.generateNodeInfo(childId, dimensionCount, cubeQueryCount, rowCountMap, hitFrequencyMap, queryMatchMap, currentCuboidSet);
                parentNode.addChild(childNode);
                nodeQueue.add(childNode);
            }
        }
        CuboidTreeResponse result = new CuboidTreeResponse();
        result.setRoot(root);
        return result;
    }

    private CuboidTreeResponse.NodeInfo generateNodeInfo(long cuboidId, int dimensionCount, long cubeQueryCount, Map<Long, Long> rowCountMap, Map<Long, Long> hitFrequencyMap, Map<Long, Long> queryMatchMap, Set<Long> currentCuboidSet) {
        Long queryCount = hitFrequencyMap == null || hitFrequencyMap.get(cuboidId) == null ? Long.valueOf(0L) : hitFrequencyMap.get(cuboidId);
        float queryRate = cubeQueryCount <= 0L ? 0.0f : queryCount.floatValue() / (float)cubeQueryCount;
        long queryExactlyMatchCount = queryMatchMap == null || queryMatchMap.get(cuboidId) == null ? 0L : queryMatchMap.get(cuboidId);
        boolean ifExist = currentCuboidSet.contains(cuboidId);
        long rowCount = rowCountMap == null || rowCountMap.size() == 0 ? 0L : rowCountMap.get(cuboidId);
        CuboidTreeResponse.NodeInfo node = new CuboidTreeResponse.NodeInfo();
        node.setId(cuboidId);
        node.setName(Cuboid.getDisplayName(cuboidId, dimensionCount));
        node.setQueryCount(queryCount);
        node.setQueryRate(Float.valueOf(queryRate));
        node.setExactlyMatchCount(queryExactlyMatchCount);
        node.setExisted(ifExist);
        node.setRowCount(rowCount);
        return node;
    }

    public Map<Long, Long> getRecommendCuboidStatistics(CubeInstance cube, Map<Long, Long> hitFrequencyMap, Map<Long, Map<Long, Pair<Long, Long>>> rollingUpCountSourceMap) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(cube.getProject());
        return CuboidRecommenderUtil.getRecommendCuboidList(cube, hitFrequencyMap, rollingUpCountSourceMap);
    }

    public Map<Long, Long> formatQueryCount(List<List<String>> orgQueryCount) {
        LinkedHashMap<Long, Long> formattedQueryCount = Maps.newLinkedHashMap();
        for (List<String> hit : orgQueryCount) {
            formattedQueryCount.put(Long.parseLong(hit.get(0)), (long)Double.parseDouble(hit.get(1)));
        }
        return formattedQueryCount;
    }

    public Map<Long, Map<Long, Pair<Long, Long>>> formatRollingUpStats(List<List<String>> orgRollingUpCount) {
        LinkedHashMap<Long, Map<Long, Pair<Long, Long>>> formattedRollingUpStats = Maps.newLinkedHashMap();
        for (List<String> rollingUp : orgRollingUpCount) {
            LinkedHashMap<Long, Pair<Long, Long>> childMap = Maps.newLinkedHashMap();
            Long srcCuboid = Long.parseLong(rollingUp.get(0));
            Long tgtCuboid = Long.parseLong(rollingUp.get(1));
            Long rollupCount = (long)Double.parseDouble(rollingUp.get(2));
            Long returnCount = (long)Double.parseDouble(rollingUp.get(3));
            childMap.put(tgtCuboid, new Pair<Long, Long>(rollupCount, returnCount));
            formattedRollingUpStats.put(srcCuboid, childMap);
        }
        return formattedRollingUpStats;
    }

    public Map<Long, Long> getCuboidHitFrequency(String cubeName, boolean isCuboidSource) {
        String cuboidColumn = isCuboidSource ? QueryCubePropertyEnum.CUBOID_SOURCE.toString() : QueryCubePropertyEnum.CUBOID_TARGET.toString();
        String hitMeasure = QueryCubePropertyEnum.WEIGHT_PER_HIT.toString();
        this.getMetricsManager();
        String table = MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectQueryCube());
        String sql = "select " + cuboidColumn + ", sum(" + hitMeasure + ") from " + table + " where " + QueryCubePropertyEnum.CUBE.toString() + " = ? group by " + cuboidColumn;
        List<List<String>> orgHitFrequency = this.getPrepareQueryResult(cubeName, sql);
        return this.formatQueryCount(orgHitFrequency);
    }

    public Map<Long, Map<Long, Pair<Long, Long>>> getCuboidRollingUpStats(String cubeName) {
        String cuboidSource = QueryCubePropertyEnum.CUBOID_SOURCE.toString();
        String cuboidTgt = QueryCubePropertyEnum.CUBOID_TARGET.toString();
        String aggCount = QueryCubePropertyEnum.AGGR_COUNT.toString();
        String returnCount = QueryCubePropertyEnum.RETURN_COUNT.toString();
        this.getMetricsManager();
        String table = MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectQueryCube());
        String sql = "select " + cuboidSource + ", " + cuboidTgt + ", avg(" + aggCount + "), avg(" + returnCount + ") from " + table + " where " + QueryCubePropertyEnum.CUBE.toString() + " = ? group by " + cuboidSource + ", " + cuboidTgt;
        List<List<String>> orgRollingUpCount = this.getPrepareQueryResult(cubeName, sql);
        return this.formatRollingUpStats(orgRollingUpCount);
    }

    public Map<Long, Long> getCuboidQueryMatchCount(String cubeName) {
        String cuboidSource = QueryCubePropertyEnum.CUBOID_SOURCE.toString();
        String hitMeasure = QueryCubePropertyEnum.WEIGHT_PER_HIT.toString();
        this.getMetricsManager();
        String table = MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectQueryCube());
        String sql = "select " + cuboidSource + ", sum(" + hitMeasure + ") from " + table + " where " + QueryCubePropertyEnum.CUBE.toString() + " = ? and " + QueryCubePropertyEnum.IF_MATCH.toString() + " = true group by " + cuboidSource;
        List<List<String>> orgMatchHitFrequency = this.getPrepareQueryResult(cubeName, sql);
        return this.formatQueryCount(orgMatchHitFrequency);
    }

    private List<List<String>> getPrepareQueryResult(String cubeName, String sql) {
        PrepareSqlRequest sqlRequest = new PrepareSqlRequest();
        sqlRequest.setProject("KYLIN_SYSTEM");
        PrepareSqlRequest.StateParam[] params = new PrepareSqlRequest.StateParam[]{new PrepareSqlRequest.StateParam()};
        params[0].setClassName("java.lang.String");
        params[0].setValue(cubeName);
        sqlRequest.setParams(params);
        sqlRequest.setSql(sql);
        return this.queryService.doQueryWithCache(sqlRequest, false).getResults();
    }

    private class HTableInfoSyncListener
    extends Broadcaster.Listener {
        private HTableInfoSyncListener() {
        }

        @Override
        public void onClearAll(Broadcaster broadcaster) throws IOException {
            CubeService.this.htableInfoCache.invalidateAll();
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String cubeName = cacheKey;
            String keyPrefix = cubeName + "/";
            for (String k : CubeService.this.htableInfoCache.asMap().keySet()) {
                if (!k.startsWith(keyPrefix)) continue;
                CubeService.this.htableInfoCache.invalidate(k);
            }
        }
    }
}

