/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.Map;
import org.apache.kylin.common.metrics.common.Metrics;
import org.apache.kylin.common.metrics.common.MetricsFactory;
import org.apache.kylin.common.metrics.metrics2.CodahaleMetrics;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="metricsService")
public class MetricsService
extends BasicService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsService.class);

    public String getMetrics(String type) throws Exception {
        if (!this.getConfig().getQueryMetrics2Enabled()) {
            throw new IllegalStateException("Please enable query metrics2");
        }
        Metrics instance = MetricsFactory.getInstance();
        String metric = null;
        if (!(instance instanceof CodahaleMetrics)) {
            throw new IllegalStateException("Please use CodahaleMetrics to collect your metrics");
        }
        try {
            metric = ((CodahaleMetrics)instance).dumpJson();
            if (StringUtils.isNotBlank(type)) {
                Map<String, Object> map = JsonUtil.readValue(metric, new TypeReference<Map<String, Object>>(){});
                metric = String.valueOf(map.get(type));
            }
        }
        catch (Exception e) {
            LOG.error("Dump metric json error, ", e);
        }
        return metric;
    }
}

