/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.Coordinator;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.StreamMetadataStoreFactory;
import org.apache.kylin.stream.coordinator.client.CoordinatorClient;
import org.apache.kylin.stream.coordinator.coordinate.StreamingCoordinator;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.source.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="streamingCoordinatorService")
public class StreamingCoordinatorService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(StreamingCoordinatorService.class);
    private StreamMetadataStore streamMetadataStore = StreamMetadataStoreFactory.getStreamMetaDataStore();
    private CoordinatorClient streamingCoordinator;

    public StreamingCoordinatorService() {
        if (KylinConfig.getInstanceFromEnv().isNewCoordinatorEnabled()) {
            logger.info("Use new version coordinator.");
            this.streamingCoordinator = StreamingCoordinator.getInstance();
        } else {
            logger.info("Use old version coordinator.");
            this.streamingCoordinator = Coordinator.getInstance();
        }
    }

    public synchronized Map<Integer, Map<String, List<Partition>>> reBalanceRecommend() {
        return this.streamingCoordinator.reBalanceRecommend();
    }

    public synchronized void reBalance(Map<Integer, Map<String, List<Partition>>> reBalancePlan) {
        this.streamingCoordinator.reBalance(reBalancePlan);
    }

    public void assignCube(String cubeName) {
        this.streamingCoordinator.assignCube(cubeName);
    }

    public void unAssignCube(String cubeName) {
        this.streamingCoordinator.unAssignCube(cubeName);
    }

    public void reAssignCube(String cubeName, CubeAssignment newAssignment) {
        this.validateAssignment(newAssignment);
        this.streamingCoordinator.reAssignCube(cubeName, newAssignment);
    }

    private void validateAssignment(CubeAssignment newAssignment) {
        Map<Integer, List<Partition>> assignments = newAssignment.getAssignments();
        Set<Integer> inputReplicaSetIDs = assignments.keySet();
        HashSet<Integer> allReplicaSetIDs = Sets.newHashSet(this.streamMetadataStore.getReplicaSetIDs());
        for (Integer inputReplicaSetID : inputReplicaSetIDs) {
            if (allReplicaSetIDs.contains(inputReplicaSetID)) continue;
            throw new IllegalArgumentException("the replica set id:" + inputReplicaSetID + " does not exist");
        }
    }

    public void pauseConsumers(String cubeName) {
        this.streamingCoordinator.pauseConsumers(cubeName);
    }

    public void resumeConsumers(String cubeName) {
        this.streamingCoordinator.resumeConsumers(cubeName);
    }

    public void replicaSetLeaderChange(int replicaSetID, Node newLeader) {
        this.streamingCoordinator.replicaSetLeaderChange(replicaSetID, newLeader);
    }

    public void createReplicaSet(ReplicaSet rs) {
        this.streamingCoordinator.createReplicaSet(rs);
    }

    public void removeReplicaSet(int rsID) {
        this.streamingCoordinator.removeReplicaSet(rsID);
    }

    public void addNodeToReplicaSet(Integer replicaSetID, String nodeID) {
        this.streamingCoordinator.addNodeToReplicaSet(replicaSetID, nodeID);
    }

    public void removeNodeFromReplicaSet(Integer replicaSetID, String nodeID) {
        this.streamingCoordinator.removeNodeFromReplicaSet(replicaSetID, nodeID);
    }

    public void onSegmentRemoteStoreComplete(String cubeName, Pair<Long, Long> segment, Node receiver) {
        this.streamingCoordinator.segmentRemoteStoreComplete(receiver, cubeName, segment);
    }
}

