/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.sql.SQLException;
import java.util.Locale;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class ConvSqlWriter
extends SqlPrettyWriter {
    private static final SqlOrderBy DUMMY_ORDER_BY_NODE = new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)new DummySqlNode(SqlParserPos.ZERO), new SqlNodeList(Lists.newArrayList(SqlLiteral.createExactNumeric((String)"1", (SqlParserPos)SqlParserPos.ZERO)), SqlParserPos.ZERO), null, null);
    private SqlConverter.IConfigurer configurer;
    private SqlPrettyWriter.FrameImpl lastFrame;

    ConvSqlWriter(SqlConverter.IConfigurer configurer) throws SQLException {
        super(configurer.getSqlDialect());
        this.configurer = configurer;
    }

    public void endList(SqlWriter.Frame frame) {
        super.endList(frame);
        this.lastFrame = frame instanceof SqlPrettyWriter.FrameImpl ? (SqlPrettyWriter.FrameImpl)frame : null;
    }

    public void fetchOffset(SqlNode fetch, SqlNode offset) {
        if (fetch == null && offset == null) {
            return;
        }
        switch (this.configurer.getPagingType().toUpperCase(Locale.ROOT)) {
            case "ROWNUM": {
                this.doWriteRowNum(fetch, offset);
                break;
            }
            case "FETCH_NEXT": {
                this.doWriteFetchNext(fetch, offset);
                break;
            }
            case "LIMIT_OFFSET": {
                this.doWriteLimitOffset(fetch, offset);
                break;
            }
            default: {
                if (this.getDialect().supportsOffsetFetch()) {
                    this.doWriteFetchNext(fetch, offset);
                    break;
                }
                this.doWriteLimitOffset(fetch, offset);
            }
        }
    }

    private void doWriteRowNum(SqlNode fetch, SqlNode offset) {
    }

    private void doWriteFetchNext(SqlNode fetch, SqlNode offset) {
        if (offset == null && !this.configurer.allowNoOffset()) {
            offset = SqlLiteral.createExactNumeric((String)"0", (SqlParserPos)SqlParserPos.ZERO);
        }
        if (fetch != null && !this.configurer.allowNoOrderByWithFetch() && this.lastFrame != null && this.lastFrame.getFrameType() != SqlWriter.FrameTypeEnum.ORDER_BY_LIST) {
            DUMMY_ORDER_BY_NODE.unparse((SqlWriter)this, 0, 0);
        }
        if (offset != null) {
            this.newlineAndIndent();
            SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
            this.keyword("OFFSET");
            offset.unparse((SqlWriter)this, -1, -1);
            this.keyword("ROWS");
            this.endList(offsetFrame);
        }
        if (fetch != null) {
            if (!this.configurer.allowFetchNoRows() && fetch instanceof SqlNumericLiteral && ((SqlNumericLiteral)fetch).toValue().equals("0")) {
                fetch = SqlLiteral.createExactNumeric((String)"1", (SqlParserPos)SqlParserPos.ZERO);
            }
            this.newlineAndIndent();
            SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
            this.keyword("FETCH");
            this.keyword("NEXT");
            fetch.unparse((SqlWriter)this, -1, -1);
            this.keyword("ROWS");
            this.keyword("ONLY");
            this.endList(fetchFrame);
        }
    }

    private void doWriteLimitOffset(SqlNode fetch, SqlNode offset) {
        if (fetch != null) {
            this.newlineAndIndent();
            SqlWriter.Frame fetchFrame = this.startList(SqlWriter.FrameTypeEnum.FETCH);
            this.keyword("LIMIT");
            fetch.unparse((SqlWriter)this, -1, -1);
            this.endList(fetchFrame);
        }
        if (offset != null) {
            this.newlineAndIndent();
            SqlWriter.Frame offsetFrame = this.startList(SqlWriter.FrameTypeEnum.OFFSET);
            this.keyword("OFFSET");
            offset.unparse((SqlWriter)this, -1, -1);
            this.endList(offsetFrame);
        }
    }

    public void identifier(String name) {
        String convertName = name;
        if (this.configurer.isCaseSensitive()) {
            convertName = this.configurer.fixIdentifierCaseSensitve(name);
        }
        if (this.configurer.enableQuote()) {
            String quoted = this.getDialect().quoteIdentifier(convertName);
            this.print(quoted);
            this.setNeedWhitespace(true);
        } else if (!this.configurer.skipHandleDefault() && convertName.trim().equalsIgnoreCase("default")) {
            String quoted = this.getDialect().quoteIdentifier(convertName);
            this.print(quoted);
            this.setNeedWhitespace(true);
        } else {
            super.identifier(convertName);
        }
    }

    public void userDefinedType(SqlDataTypeSpec typeSpec, int leftPrec, int rightPrec) {
        this.keyword(typeSpec.getTypeName().getSimple());
        int precision = typeSpec.getPrecision();
        int scale = typeSpec.getScale();
        if (precision >= 0) {
            SqlWriter.Frame frame = this.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            this.print(precision);
            if (scale >= 0) {
                this.sep(",", true);
                this.print(scale);
            }
            this.endList(frame);
        }
    }

    public boolean inQuery() {
        return this.frame == null || this.frame.getFrameType() == SqlWriter.FrameTypeEnum.ORDER_BY || this.frame.getFrameType() == SqlWriter.FrameTypeEnum.WITH || this.frame.getFrameType() == SqlWriter.FrameTypeEnum.SETOP || this.frame.getFrameType() == SqlWriter.FrameTypeEnum.WITH_ITEM;
    }

    public boolean isQuoteAllIdentifiers() {
        return super.isQuoteAllIdentifiers();
    }

    public void writeWith(SqlCall call, int leftPrec, int rightPrec) {
        SqlWith with = (SqlWith)call;
        SqlWriter.Frame frame = this.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.WITH, "WITH", "");
        for (SqlNode node : with.withList) {
            this.sep(",");
            node.unparse((SqlWriter)this, 0, 0);
        }
        with.body.unparse((SqlWriter)this, 100, 100);
        this.endList(frame);
    }

    public void writeWithItem(SqlCall call, SqlWithItem.SqlWithItemOperator sqlWithItemOperator, int leftPrec, int rightPrec) {
        SqlWithItem withItem = (SqlWithItem)call;
        int leftP = sqlWithItemOperator.getLeftPrec();
        int rightP = sqlWithItemOperator.getRightPrec();
        withItem.name.unparse((SqlWriter)this, leftP, rightP);
        if (withItem.columnList != null) {
            withItem.columnList.unparse((SqlWriter)this, leftP, rightP);
        }
        this.keyword("AS");
        SqlWriter.Frame frame = this.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.WITH_ITEM, "(", ")");
        withItem.query.unparse((SqlWriter)this, 10, 10);
        this.endList(frame);
    }

    private static class DummySqlNode
    extends SqlNodeList {
        private DummySqlNode(SqlParserPos pos) {
            super(pos);
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.sep("");
        }
    }
}

