/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.DefaultConfigurer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDefProvider;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;

public class GenericSqlConverter {
    private final Cache<String, SqlConverter> sqlConverterCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(30L).build();

    public String convertSql(String originSql, String sourceDialect, String targetDialect) throws SQLException {
        SqlConverter sqlConverter = this.getSqlConverter(sourceDialect, targetDialect);
        return sqlConverter.convertSql(originSql);
    }

    private SqlConverter getSqlConverter(String sourceDialect, String targetDialect) throws SQLException {
        String cacheKey = sourceDialect + "_" + targetDialect;
        SqlConverter sqlConverter = this.sqlConverterCache.getIfPresent(cacheKey);
        if (sqlConverter == null) {
            sqlConverter = this.createSqlConverter(sourceDialect, targetDialect);
            this.sqlConverterCache.put(cacheKey, sqlConverter);
        }
        return sqlConverter;
    }

    private SqlConverter createSqlConverter(String sourceDialect, String targetDialect) throws SQLException {
        DataSourceDefProvider provider = DataSourceDefProvider.getInstance();
        DataSourceDef sourceDs = provider.getById(sourceDialect);
        DataSourceDef targetDs = provider.getById(targetDialect);
        ConvMaster convMaster = new ConvMaster(sourceDs, targetDs);
        DefaultConfigurer configurer = new DefaultConfigurer(targetDs);
        return new SqlConverter(configurer, convMaster);
    }
}

