/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.extensible;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTableReader
implements IReadableTable.TableReader {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTableReader.class);
    private String dbName;
    private String tableName;
    private Connection conn;
    private Statement statement;
    private ResultSet rs;
    private int colCount;

    public JdbcTableReader(JdbcConnector dataSource, String dbName, String tableName) throws IOException {
        this.dbName = dbName;
        this.tableName = tableName;
        String sql = dataSource.convertSql(String.format(Locale.ROOT, "select * from %s.%s", dbName, tableName));
        try {
            this.conn = dataSource.getConnection();
            this.statement = this.conn.createStatement();
            this.rs = this.statement.executeQuery(sql);
            this.colCount = this.rs.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            logger.error("error when get jdbc tableReader.", e);
            throw new IOException(String.format(Locale.ROOT, "error while exec %s", sql));
        }
    }

    @Override
    public boolean next() throws IOException {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String[] getRow() {
        String[] ret = new String[this.colCount];
        for (int i = 1; i <= this.colCount; ++i) {
            try {
                Object o = this.rs.getObject(i);
                String result = null == o || o instanceof byte[] ? null : o.toString();
                ret[i - 1] = result;
                continue;
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        DBUtils.closeQuietly(this.rs);
        DBUtils.closeQuietly(this.statement);
        DBUtils.closeQuietly(this.conn);
    }

    public String toString() {
        return "jdbc table reader for: " + this.dbName + "." + this.tableName;
    }
}

