/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.gridtable.StorageLimitLevel;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.shaded.com.google.common.collect.Range;
import org.apache.kylin.storage.IStorageQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContext {
    private static final Logger logger = LoggerFactory.getLogger(StorageContext.class);
    public final int ctxId;
    private StorageURL connUrl;
    private int limit = Integer.MAX_VALUE;
    private boolean overlookOuterLimit = false;
    private int offset = 0;
    private int finalPushDownLimit = Integer.MAX_VALUE;
    private StorageLimitLevel storageLimitLevel = StorageLimitLevel.NO_LIMIT;
    private boolean hasSort = false;
    private boolean acceptPartialResult = false;
    private boolean exactAggregation = false;
    private boolean needStorageAggregation = false;
    private boolean enableCoprocessor = false;
    private boolean enableStreamAggregate = false;
    private IStorageQuery storageQuery;
    private AtomicLong processedRowCount = new AtomicLong();
    private Cuboid cuboid;
    private CuboidToGridTableMapping mapping;
    private boolean partialResultReturned = false;
    private Range<Long> reusedPeriod;
    private long filterMask;

    public StorageContext() {
        this(0);
    }

    public StorageContext(int ctxId) {
        this.ctxId = ctxId;
    }

    public long getFilterMask() {
        return this.filterMask;
    }

    public void setFilterMask(long filterMask) {
        this.filterMask = filterMask;
    }

    public StorageURL getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(StorageURL connUrl) {
        this.connUrl = connUrl;
    }

    private int getLimit() {
        if (this.overlookOuterLimit || BackdoorToggles.getStatementMaxRows() == null || BackdoorToggles.getStatementMaxRows() == 0) {
            return this.limit;
        }
        return Math.min(this.limit, BackdoorToggles.getStatementMaxRows());
    }

    public void setLimit(int l) {
        if (this.limit != Integer.MAX_VALUE) {
            logger.warn("Setting limit to {} but in current olap context, the limit is already {}, won't apply", (Object)l, (Object)this.limit);
        } else {
            this.limit = l;
        }
    }

    public void setOverlookOuterLimit() {
        this.overlookOuterLimit = true;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isLimitPushDownEnabled() {
        return StorageContext.isValidPushDownLimit(this.finalPushDownLimit);
    }

    public static boolean isValidPushDownLimit(long finalPushDownLimit) {
        return finalPushDownLimit < Integer.MAX_VALUE && finalPushDownLimit > 0L;
    }

    public int getFinalPushDownLimit() {
        return this.finalPushDownLimit;
    }

    public StorageLimitLevel getStorageLimitLevel() {
        return this.storageLimitLevel;
    }

    public void applyLimitPushDown(IRealization realization, StorageLimitLevel storageLimitLevel) {
        if (storageLimitLevel == StorageLimitLevel.NO_LIMIT) {
            return;
        }
        if (!realization.supportsLimitPushDown()) {
            logger.warn("Not enabling limit push down because cube storage type not supported");
            return;
        }
        long temp = (long)this.getOffset() + (long)this.getLimit();
        if (!StorageContext.isValidPushDownLimit(temp)) {
            logger.warn("Not enabling limit push down because current limit is invalid: " + this.getLimit());
            return;
        }
        this.finalPushDownLimit = (int)temp;
        this.storageLimitLevel = storageLimitLevel;
        logger.info("Enabling limit push down: {} at level: {}", (Object)temp, (Object)storageLimitLevel);
    }

    public boolean mergeSortPartitionResults() {
        return StorageContext.mergeSortPartitionResults(this.finalPushDownLimit);
    }

    public static boolean mergeSortPartitionResults(int finalPushDownLimit) {
        return StorageContext.isValidPushDownLimit(finalPushDownLimit);
    }

    public void markSort() {
        this.hasSort = true;
    }

    public boolean hasSort() {
        return this.hasSort;
    }

    public void setCuboid(Cuboid c) {
        this.cuboid = c;
    }

    public Cuboid getCuboid() {
        return this.cuboid;
    }

    public CuboidToGridTableMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(CuboidToGridTableMapping mapping) {
        this.mapping = mapping;
    }

    public long getProcessedRowCount() {
        return this.processedRowCount.get();
    }

    public long increaseProcessedRowCount(long count) {
        return this.processedRowCount.addAndGet(count);
    }

    public boolean isAcceptPartialResult() {
        return this.acceptPartialResult;
    }

    public void setAcceptPartialResult(boolean acceptPartialResult) {
        this.acceptPartialResult = acceptPartialResult;
    }

    public boolean isPartialResultReturned() {
        return this.partialResultReturned;
    }

    public void setPartialResultReturned(boolean partialResultReturned) {
        this.partialResultReturned = partialResultReturned;
    }

    public boolean isNeedStorageAggregation() {
        return this.needStorageAggregation;
    }

    public void setNeedStorageAggregation(boolean needStorageAggregation) {
        this.needStorageAggregation = needStorageAggregation;
    }

    public void setExactAggregation(boolean isExactAggregation) {
        this.exactAggregation = isExactAggregation;
    }

    public boolean isExactAggregation() {
        return this.exactAggregation;
    }

    public void enableCoprocessor() {
        this.enableCoprocessor = true;
    }

    public boolean isCoprocessorEnabled() {
        return this.enableCoprocessor;
    }

    public Range<Long> getReusedPeriod() {
        return this.reusedPeriod;
    }

    public void setReusedPeriod(Range<Long> reusedPeriod) {
        this.reusedPeriod = reusedPeriod;
    }

    public IStorageQuery getStorageQuery() {
        return this.storageQuery;
    }

    public void setStorageQuery(IStorageQuery storageQuery) {
        this.storageQuery = storageQuery;
    }

    public boolean isStreamAggregateEnabled() {
        return this.enableStreamAggregate;
    }

    public void enableStreamAggregate() {
        this.enableStreamAggregate = true;
    }
}

