/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.client;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.stream.coordinator.Coordinator;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.client.CoordinatorClient;
import org.apache.kylin.stream.coordinator.client.HttpCoordinatorClient;
import org.apache.kylin.stream.coordinator.coordinate.StreamingCoordinator;
import org.apache.kylin.stream.core.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(CoordinatorClientFactory.class);

    private CoordinatorClientFactory() {
    }

    public static CoordinatorClient createCoordinatorClient(StreamMetadataStore streamMetadataStore) {
        if (CoordinatorClientFactory.isCoordinatorCoLocate(streamMetadataStore)) {
            if (KylinConfig.getInstanceFromEnv().isNewCoordinatorEnabled()) {
                logger.info("Use new version coordinator.");
                return StreamingCoordinator.getInstance();
            }
            logger.info("Use old version coordinator.");
            return Coordinator.getInstance();
        }
        return new HttpCoordinatorClient(streamMetadataStore);
    }

    private static boolean isCoordinatorCoLocate(StreamMetadataStore streamMetadataStore) {
        try {
            Node coordinatorNode = streamMetadataStore.getCoordinatorNode();
            if (coordinatorNode == null) {
                logger.warn("no coordinator node registered");
                return false;
            }
            String hostAddr = KylinConfig.getInstanceFromEnv().getServerRestAddress();
            String[] hostAddrInfo = hostAddr.split(":");
            if (hostAddrInfo.length < 2) {
                logger.error("kylin.server.host-address {} is not qualified ", (Object)hostAddr);
                throw new RuntimeException("kylin.server.host-address " + hostAddr + " is not qualified");
            }
            String host = hostAddrInfo[0];
            int port = Integer.parseInt(hostAddrInfo[1]);
            if (!host.equals(coordinatorNode.getHost()) || port != coordinatorNode.getPort()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Error when check network interface.", e);
        }
        return true;
    }
}

