/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage;

import java.io.File;
import java.io.IOException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.storage.IStreamingSegmentStore;

public class StreamingCubeSegment
implements Comparable<StreamingCubeSegment> {
    private volatile State state;
    private IStreamingSegmentStore segmentStore;
    private long createTime;
    private long lastUpdateTime;
    private long latestEventTimeStamp = 0L;
    private long latestEventLatecy = 0L;
    private String cubeName;
    private CubeInstance cubeInstance;
    private String segmentName;
    private long dateRangeStart;
    private long dateRangeEnd;

    public StreamingCubeSegment(CubeInstance cubeInstance, IStreamingSegmentStore segmentStore, long segmentStart, long segmentEnd) {
        this.cubeInstance = cubeInstance;
        this.cubeName = cubeInstance.getName();
        this.dateRangeStart = segmentStart;
        this.dateRangeEnd = segmentEnd;
        this.createTime = System.currentTimeMillis();
        this.lastUpdateTime = System.currentTimeMillis();
        this.state = State.ACTIVE;
        this.segmentStore = segmentStore;
        this.segmentName = CubeSegment.makeSegmentName(new SegmentRange.TSRange(segmentStart, segmentEnd), null, cubeInstance.getModel());
    }

    public static StreamingCubeSegment parseSegment(CubeInstance cubeInstance, File segmentFolder, IStreamingSegmentStore segmentStore) {
        Pair<Long, Long> segmentStartEnd = CubeSegment.parseSegmentName(segmentFolder.getName());
        StreamingCubeSegment segment = new StreamingCubeSegment(cubeInstance, segmentStore, segmentStartEnd.getFirst(), segmentStartEnd.getSecond());
        State state = segmentStore.getSegmentState();
        segment.saveState(state);
        return segment;
    }

    public IStreamingSegmentStore getSegmentStore() {
        return this.segmentStore;
    }

    public void immutable() {
        this.segmentStore.persist();
        this.saveState(State.IMMUTABLE);
    }

    public boolean isActive() {
        return State.ACTIVE == this.state;
    }

    public boolean isImmutable() {
        return State.IMMUTABLE == this.state || State.REMOTE_PERSISTED == this.state;
    }

    public boolean isPersistToRemote() {
        return State.REMOTE_PERSISTED == this.state;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public long getLatestEventTimeStamp() {
        return this.latestEventTimeStamp;
    }

    public long getLatestEventLatecy() {
        return this.latestEventLatecy;
    }

    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    public boolean isLongLatencySegment() {
        return this.dateRangeStart == 0L;
    }

    public Pair<Long, Long> getSegmentRange() {
        return new Pair<Long, Long>(this.dateRangeStart, this.dateRangeEnd);
    }

    public File getDataSegmentFolder() {
        return this.segmentStore.getStorePath();
    }

    public CubeInstance getCubeInstance() {
        return this.cubeInstance;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public State getState() {
        return this.state;
    }

    public void saveState(State state) {
        this.segmentStore.setSegmentState(state);
        this.state = state;
    }

    public void addEvent(StreamingMessage event) {
        this.segmentStore.addEvent(event);
        this.latestEventTimeStamp = event.getTimestamp();
        this.latestEventLatecy = System.currentTimeMillis() - event.getTimestamp();
    }

    public void purge() {
        this.segmentStore.purge();
    }

    public void close() throws IOException {
        this.segmentStore.close();
    }

    @Override
    public int compareTo(StreamingCubeSegment o) {
        if (!this.getCubeName().equals(o.getCubeName())) {
            return this.getCubeName().compareTo(o.getCubeName());
        }
        return Long.compare(this.getDateRangeStart(), o.getDateRangeStart());
    }

    public String toString() {
        return "StreamingCubeSegment [cubeName=" + this.cubeName + ", segmentName=" + this.segmentName + "]";
    }

    public static enum State {
        ACTIVE,
        IMMUTABLE,
        REMOTE_PERSISTED;

    }
}

