/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.dict.MultipleDictionaryValueEnumerator;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.io.ByteStreams;
import org.apache.kylin.shaded.com.google.common.io.CountingOutputStream;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncodingFactory;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreCache;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreDimDesc;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreMetricsDesc;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentCuboidReader;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.FragmentId;
import org.apache.kylin.stream.core.storage.columnar.FragmentsMergeResult;
import org.apache.kylin.stream.core.storage.columnar.ParsedStreamingCubeInfo;
import org.apache.kylin.stream.core.storage.columnar.RawRecord;
import org.apache.kylin.stream.core.storage.columnar.StringArrayComparator;
import org.apache.kylin.stream.core.storage.columnar.invertindex.FixLenIIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.invertindex.IIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.invertindex.SeqIIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimensionMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.MetricMetaInfo;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentFilesMerger {
    private static Logger logger = LoggerFactory.getLogger(FragmentFilesMerger.class);
    private ParsedStreamingCubeInfo parsedCubeInfo;
    private File segmentFolder;
    private File mergeWorkingDirectory;

    public FragmentFilesMerger(ParsedStreamingCubeInfo parsedCubeInfo, File segmentFolder) {
        this.parsedCubeInfo = parsedCubeInfo;
        this.segmentFolder = segmentFolder;
        this.mergeWorkingDirectory = new File(segmentFolder, ".merge-" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FragmentsMergeResult merge(List<DataSegmentFragment> fragmentList) throws IOException {
        Map<String, CuboidMetaInfo> cuboidMetaInfoMap;
        if (!this.mergeWorkingDirectory.exists()) {
            this.mergeWorkingDirectory.mkdirs();
        } else {
            logger.info("clean the merge working dir:{}", (Object)this.mergeWorkingDirectory.getAbsolutePath());
            FileUtils.cleanDirectory(this.mergeWorkingDirectory);
        }
        Collections.sort(fragmentList);
        FragmentId mergedFragmentId = new FragmentId(fragmentList.get(0).getFragmentId().getStartId(), fragmentList.get(fragmentList.size() - 1).getFragmentId().getEndId());
        ArrayList<FragmentData> fragmentDataList = Lists.newArrayList();
        HashMap<TblColRef, List<Dictionary<String>>> dimDictListMap = Maps.newHashMap();
        HashMap<FragmentId, Map<TblColRef, Dictionary<String>>> fragmentDictionaryMaps = Maps.newHashMap();
        List<Object> additionalCuboidsToMerge = null;
        long minMergedFragmentEventTime = Long.MAX_VALUE;
        long maxMergedFragmentEventTime = 0L;
        long originNumOfRows = 0L;
        for (DataSegmentFragment fragment : fragmentList) {
            FragmentData fragmentData = ColumnarStoreCache.getInstance().startReadFragmentData(fragment);
            FragmentMetaInfo fragmentMetaInfo = fragmentData.getFragmentMetaInfo();
            long fragmentMinTime = fragmentMetaInfo.getMinEventTime();
            long fragmentMaxTime = fragmentMetaInfo.getMaxEventTime();
            originNumOfRows += fragmentMetaInfo.getOriginNumOfRows();
            if (fragmentMinTime < minMergedFragmentEventTime) {
                minMergedFragmentEventTime = fragmentMinTime;
            }
            if (fragmentMaxTime > maxMergedFragmentEventTime) {
                maxMergedFragmentEventTime = fragmentMaxTime;
            }
            if (additionalCuboidsToMerge == null) {
                cuboidMetaInfoMap = fragmentMetaInfo.getCuboidMetaInfoMap();
                additionalCuboidsToMerge = cuboidMetaInfoMap != null ? Lists.transform(Lists.newArrayList(cuboidMetaInfoMap.keySet()), new Function<String, Long>(){

                    @Override
                    @Nullable
                    public Long apply(@Nullable String input) {
                        return Long.valueOf(input);
                    }
                }) : Lists.newArrayList();
            }
            fragmentDataList.add(fragmentData);
            Map<TblColRef, Dictionary<String>> dictionaryMap = fragmentData.getDimensionDictionaries(this.parsedCubeInfo.dimensionsUseDictEncoding);
            fragmentDictionaryMaps.put(fragment.getFragmentId(), dictionaryMap);
            for (Map.Entry<TblColRef, Dictionary<String>> entry : dictionaryMap.entrySet()) {
                ArrayList<Dictionary<String>> dictionaryList = (ArrayList<Dictionary<String>>)dimDictListMap.get(entry.getKey());
                if (dictionaryList == null) {
                    dictionaryList = Lists.newArrayList();
                    dimDictListMap.put(entry.getKey(), dictionaryList);
                }
                dictionaryList.add(entry.getValue());
            }
        }
        File mergedFragmentDataFile = new File(this.mergeWorkingDirectory, mergedFragmentId + ".data");
        File mergedFragmentMetaFile = new File(this.mergeWorkingDirectory, mergedFragmentId + ".meta");
        try {
            FragmentMetaInfo mergedFragmentMeta = new FragmentMetaInfo();
            CountingOutputStream fragmentDataOutput = new CountingOutputStream(new BufferedOutputStream(FileUtils.openOutputStream(mergedFragmentDataFile)));
            Map<TblColRef, Dictionary<String>> mergedDictMap = this.mergeAndPersistDictionaries(mergedFragmentMeta, dimDictListMap, fragmentDataOutput);
            logger.info("merge basic cuboid");
            CuboidMetaInfo basicCuboidMeta = this.mergeAndPersistCuboidData(fragmentDataList, fragmentDictionaryMaps, mergedDictMap, fragmentDataOutput, this.parsedCubeInfo.basicCuboid.getId());
            mergedFragmentMeta.setBasicCuboidMetaInfo(basicCuboidMeta);
            long totalRowCnt = basicCuboidMeta.getNumberOfRows();
            cuboidMetaInfoMap = Maps.newHashMap();
            for (Long l : additionalCuboidsToMerge) {
                logger.info("merge cuboid:{}", (Object)l);
                CuboidMetaInfo cuboidMeta = this.mergeAndPersistCuboidData(fragmentDataList, fragmentDictionaryMaps, mergedDictMap, fragmentDataOutput, l);
                cuboidMetaInfoMap.put(String.valueOf(l), cuboidMeta);
                totalRowCnt += cuboidMeta.getNumberOfRows();
            }
            mergedFragmentMeta.setMaxEventTime(maxMergedFragmentEventTime);
            mergedFragmentMeta.setMinEventTime(minMergedFragmentEventTime);
            mergedFragmentMeta.setCuboidMetaInfoMap(cuboidMetaInfoMap);
            mergedFragmentMeta.setFragmentId(mergedFragmentId.toString());
            mergedFragmentMeta.setNumberOfRows(totalRowCnt);
            mergedFragmentMeta.setOriginNumOfRows(originNumOfRows);
            fragmentDataOutput.flush();
            fragmentDataOutput.close();
            FileOutputStream metaOutputStream = FileUtils.openOutputStream(mergedFragmentMetaFile);
            JsonUtil.writeValueIndent(metaOutputStream, mergedFragmentMeta);
            metaOutputStream.flush();
            metaOutputStream.close();
        }
        catch (Throwable throwable) {
            for (DataSegmentFragment fragment : fragmentList) {
                ColumnarStoreCache.getInstance().finishReadFragmentData(fragment);
            }
            throw throwable;
        }
        for (DataSegmentFragment fragment : fragmentList) {
            ColumnarStoreCache.getInstance().finishReadFragmentData(fragment);
        }
        FragmentsMergeResult result = new FragmentsMergeResult(fragmentList, mergedFragmentId, mergedFragmentMetaFile, mergedFragmentDataFile);
        return result;
    }

    public void cleanMergeDirectory() {
        FileUtils.deleteQuietly(this.mergeWorkingDirectory);
    }

    private Map<TblColRef, Dictionary<String>> mergeAndPersistDictionaries(FragmentMetaInfo fragmentMetaInfo, Map<TblColRef, List<Dictionary<String>>> dimDictListMap, CountingOutputStream fragmentOut) throws IOException {
        logger.info("merge dimension dictionaries");
        HashMap<TblColRef, Dictionary<String>> mergedDictMap = Maps.newHashMap();
        ArrayList<DimDictionaryMetaInfo> dimDictionaryMetaInfos = Lists.newArrayList();
        for (TblColRef dimension : this.parsedCubeInfo.dimensionsUseDictEncoding) {
            List<Dictionary<String>> dicts = dimDictListMap.get(dimension);
            MultipleDictionaryValueEnumerator multipleDictionaryValueEnumerator = new MultipleDictionaryValueEnumerator(dimension.getType(), dicts);
            Dictionary<String> mergedDict = DictionaryGenerator.buildDictionary(dimension.getType(), multipleDictionaryValueEnumerator);
            mergedDictMap.put(dimension, mergedDict);
            DimDictionaryMetaInfo dimDictionaryMetaInfo = new DimDictionaryMetaInfo();
            dimDictionaryMetaInfo.setDimName(dimension.getName());
            dimDictionaryMetaInfo.setDictType(mergedDict.getClass().getName());
            dimDictionaryMetaInfo.setStartOffset((int)fragmentOut.getCount());
            DictionarySerializer.serialize(mergedDict, fragmentOut);
            dimDictionaryMetaInfo.setDictLength((int)fragmentOut.getCount() - dimDictionaryMetaInfo.getStartOffset());
            dimDictionaryMetaInfos.add(dimDictionaryMetaInfo);
        }
        fragmentMetaInfo.setDimDictionaryMetaInfos(dimDictionaryMetaInfos);
        return mergedDictMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CuboidMetaInfo mergeAndPersistCuboidData(List<FragmentData> fragmentDataList, Map<FragmentId, Map<TblColRef, Dictionary<String>>> fragmentDictionaryMaps, Map<TblColRef, Dictionary<String>> mergedDictMap, CountingOutputStream fragmentDataOutput, long cuboidId) throws IOException {
        int bytesRead;
        int offset;
        int i;
        int i2;
        int i3;
        ArrayList<FragmentCuboidReader> fragmentCuboidReaders = Lists.newArrayList();
        ArrayList<DimensionEncoding[]> fragmentsDimensionEncodings = Lists.newArrayList();
        ParsedStreamingCubeInfo.CuboidInfo cuboidInfo = this.parsedCubeInfo.getCuboidInfo(cuboidId);
        TblColRef[] dimensions = cuboidInfo.getDimensions();
        int dimCount = dimensions.length;
        for (FragmentData fragmentData : fragmentDataList) {
            FragmentMetaInfo fragmentMetaInfo = fragmentData.getFragmentMetaInfo();
            CuboidMetaInfo cuboidMetaInfo = cuboidId == this.parsedCubeInfo.basicCuboid.getId() ? fragmentMetaInfo.getBasicCuboidMetaInfo() : fragmentMetaInfo.getCuboidMetaInfo(cuboidId);
            Map<TblColRef, Dictionary<String>> dictMap = fragmentDictionaryMaps.get(FragmentId.parse(fragmentMetaInfo.getFragmentId()));
            DimensionEncoding[] dimensionEncodings = ParsedStreamingCubeInfo.getDimensionEncodings(this.parsedCubeInfo.cubeDesc, dimensions, dictMap);
            FragmentCuboidReader fragmentCuboidReader = new FragmentCuboidReader(this.parsedCubeInfo.cubeDesc, fragmentData, cuboidMetaInfo, cuboidInfo.getDimensions(), this.parsedCubeInfo.measureDescs, dimensionEncodings);
            fragmentCuboidReaders.add(fragmentCuboidReader);
            fragmentsDimensionEncodings.add(dimensionEncodings);
        }
        MeasureAggregators measureAggregators = new MeasureAggregators(this.parsedCubeInfo.measureDescs);
        DimensionEncoding[] mergedDimEncodings = ParsedStreamingCubeInfo.getDimensionEncodings(this.parsedCubeInfo.cubeDesc, cuboidInfo.getDimensions(), mergedDictMap);
        IIColumnDescriptor[] invertIndexColDescs = new IIColumnDescriptor[dimCount];
        for (int i4 = 0; i4 < mergedDimEncodings.length; ++i4) {
            TblColRef dim = dimensions[i4];
            DimensionEncoding encoding = mergedDimEncodings[i4];
            if (encoding instanceof DictionaryDimEnc) {
                DictionaryDimEnc dictDimEnc = (DictionaryDimEnc)encoding;
                Dictionary<String> dict = dictDimEnc.getDictionary();
                if (dict instanceof TrieDictionary) {
                    invertIndexColDescs[i4] = new SeqIIColumnDescriptor(dim.getName(), dict.getMinId(), dict.getMaxId());
                    continue;
                }
                invertIndexColDescs[i4] = new FixLenIIColumnDescriptor(dim.getName(), encoding.getLengthOfEncoding());
                continue;
            }
            invertIndexColDescs[i4] = new FixLenIIColumnDescriptor(dim.getName(), encoding.getLengthOfEncoding());
        }
        CuboidColumnDataWriter[] dimDataWriters = new CuboidColumnDataWriter[dimCount];
        CuboidMetricDataWriter[] metricDataWriters = new CuboidMetricDataWriter[this.parsedCubeInfo.measureCount];
        ColumnarMetricsEncoding[] metricsEncodings = new ColumnarMetricsEncoding[this.parsedCubeInfo.measureCount];
        for (i3 = 0; i3 < dimDataWriters.length; ++i3) {
            dimDataWriters[i3] = new CuboidColumnDataWriter(cuboidId, dimensions[i3].getName());
        }
        for (i3 = 0; i3 < metricDataWriters.length; ++i3) {
            metricDataWriters[i3] = new CuboidMetricDataWriter(cuboidId, this.parsedCubeInfo.measureDescs[i3].getName(), this.parsedCubeInfo.getMeasureTypeSerializer(i3).maxLength());
            metricsEncodings[i3] = ColumnarMetricsEncodingFactory.create(this.parsedCubeInfo.measureDescs[i3].getFunction().getReturnDataType());
        }
        FragmentCuboidDataMerger fragmentCuboidDataMerger = new FragmentCuboidDataMerger(cuboidInfo, fragmentCuboidReaders, fragmentsDimensionEncodings, mergedDimEncodings, measureAggregators, metricsEncodings);
        logger.info("start to merge and write dimension data");
        int rowCnt = 0;
        while (fragmentCuboidDataMerger.hasNext()) {
            int i5;
            RawRecord rawRecord = fragmentCuboidDataMerger.next();
            for (i5 = 0; i5 < rawRecord.getDimensions().length; ++i5) {
                byte[] bytes = rawRecord.getDimensions()[i5];
                dimDataWriters[i5].write(bytes);
            }
            for (i5 = 0; i5 < rawRecord.getMetrics().length; ++i5) {
                metricDataWriters[i5].write(rawRecord.getMetrics()[i5]);
            }
            ++rowCnt;
        }
        for (i2 = 0; i2 < dimDataWriters.length; ++i2) {
            dimDataWriters[i2].close();
        }
        for (i2 = 0; i2 < metricDataWriters.length; ++i2) {
            metricDataWriters[i2].close();
        }
        logger.info("all dimensions data wrote to separate file");
        logger.info("start to merge dimension data and build invert index");
        CuboidMetaInfo cuboidMeta = new CuboidMetaInfo();
        cuboidMeta.setNumberOfRows(rowCnt);
        cuboidMeta.setNumberOfDim(dimCount);
        cuboidMeta.setNumberOfMetrics(this.parsedCubeInfo.measureCount);
        ArrayList<DimensionMetaInfo> dimensionMetaList = Lists.newArrayList();
        ArrayList<MetricMetaInfo> metricMetaList = Lists.newArrayList();
        cuboidMeta.setDimensionsInfo(dimensionMetaList);
        cuboidMeta.setMetricsInfo(metricMetaList);
        for (i = 0; i < dimDataWriters.length; ++i) {
            DimensionEncoding encoding = mergedDimEncodings[i];
            int dimFixLen = encoding.getLengthOfEncoding();
            BufferedInputStream dimInput = new BufferedInputStream(FileUtils.openInputStream(dimDataWriters[i].getOutputFile()));
            try {
                DimensionMetaInfo dimensionMeta = new DimensionMetaInfo();
                dimensionMeta.setName(dimensions[i].getName());
                int startOffset = (int)fragmentDataOutput.getCount();
                dimensionMeta.setStartOffset(startOffset);
                ColumnarStoreDimDesc cStoreDimDesc = ColumnarStoreDimDesc.getDefaultCStoreDimDesc(this.parsedCubeInfo.cubeDesc, dimensions[i].getName(), encoding);
                ColumnDataWriter columnDataWriter = cStoreDimDesc.getDimWriter(fragmentDataOutput, rowCnt);
                for (int j = 0; j < rowCnt; ++j) {
                    byte[] dimValue = new byte[dimFixLen];
                    offset = 0;
                    while ((bytesRead = ((InputStream)dimInput).read(dimValue, offset, dimValue.length - offset)) != -1 && (offset += bytesRead) < dimValue.length) {
                    }
                    if (DimensionEncoding.isNull(dimValue, 0, dimValue.length)) {
                        dimensionMeta.setHasNull(true);
                    }
                    invertIndexColDescs[i].getWriter().addValue(dimValue);
                    columnDataWriter.write(dimValue);
                }
                columnDataWriter.flush();
                int dimLen = (int)fragmentDataOutput.getCount() - startOffset;
                dimensionMeta.setDataLength(dimLen);
                invertIndexColDescs[i].getWriter().write(fragmentDataOutput);
                dimensionMeta.setIndexLength((int)fragmentDataOutput.getCount() - startOffset - dimLen);
                dimensionMeta.setCompression(cStoreDimDesc.getCompression().name());
                dimensionMetaList.add(dimensionMeta);
                continue;
            }
            finally {
                if (null != dimInput) {
                    ((InputStream)dimInput).close();
                }
            }
        }
        for (i = 0; i < metricDataWriters.length; ++i) {
            DataInputStream metricInput = new DataInputStream(new BufferedInputStream(FileUtils.openInputStream(metricDataWriters[i].getOutputFile())));
            try {
                ColumnarMetricsEncoding metricsEncoding = ColumnarMetricsEncodingFactory.create(this.parsedCubeInfo.measureDescs[i].getFunction().getReturnDataType());
                ColumnarStoreMetricsDesc cStoreMetricsDesc = ColumnarStoreMetricsDesc.getDefaultCStoreMetricsDesc(metricsEncoding);
                ColumnDataWriter columnDataWriter = cStoreMetricsDesc.getMetricsWriter(fragmentDataOutput, rowCnt);
                MetricMetaInfo metricMeta = new MetricMetaInfo();
                metricMeta.setName(this.parsedCubeInfo.measureDescs[i].getName());
                int startOffset = (int)fragmentDataOutput.getCount();
                metricMeta.setStartOffset(startOffset);
                for (int j = 0; j < rowCnt; ++j) {
                    int metricLen = metricInput.readInt();
                    byte[] metricValue = new byte[metricLen];
                    offset = 0;
                    while ((bytesRead = metricInput.read(metricValue, offset, metricValue.length - offset)) != -1 && (offset += bytesRead) < metricValue.length) {
                    }
                    columnDataWriter.write(metricValue);
                }
                columnDataWriter.flush();
                int metricsLen = (int)fragmentDataOutput.getCount() - startOffset;
                metricMeta.setMetricLength(metricsLen);
                metricMeta.setMaxSerializeLength(metricDataWriters[i].getMaxValueLen());
                metricMeta.setCompression(cStoreMetricsDesc.getCompression().name());
                metricMetaList.add(metricMeta);
                ByteStreams.copy(metricInput, fragmentDataOutput);
                continue;
            }
            finally {
                if (null != metricInput) {
                    metricInput.close();
                }
            }
        }
        return cuboidMeta;
    }

    private static class DecodedRecord {
        String[] dimensions;
        byte[][] metrics;

        DecodedRecord(String[] dimensions, byte[][] metrics) {
            this.dimensions = dimensions;
            this.metrics = metrics;
        }
    }

    private static class RecordDecoder {
        private DimensionEncoding[] dimEncodings;

        public RecordDecoder(DimensionEncoding[] dimEncodings) {
            this.dimEncodings = dimEncodings;
        }

        public DecodedRecord decode(RawRecord rawRecord) {
            byte[][] rawDimValues = rawRecord.getDimensions();
            String[] dimValues = new String[rawDimValues.length];
            for (int i = 0; i < dimValues.length; ++i) {
                byte[] dimVal = rawDimValues[i];
                dimValues[i] = this.dimEncodings[i].decode(dimVal, 0, dimVal.length);
            }
            byte[][] metricsValues = rawRecord.getMetrics();
            return new DecodedRecord(dimValues, (byte[][])Arrays.copyOf(metricsValues, metricsValues.length));
        }
    }

    public class FragmentCuboidDataMerger
    implements Iterator<RawRecord> {
        private List<DimensionEncoding[]> fragmentsDimensionEncodings;
        private DimensionEncoding[] mergedDimensionEncodings;
        private List<RecordDecoder> fragmentsRecordDecoders;
        private List<Iterator<RawRecord>> fragmentsCuboidRecords;
        private PriorityQueue<Pair<DecodedRecord, Integer>> minHeap;
        private MeasureAggregators resultAggrs;
        private DataTypeSerializer[] metricsSerializers;
        private RawRecord oneRawRecord;
        private ByteBuffer metricsBuf;

        public FragmentCuboidDataMerger(ParsedStreamingCubeInfo.CuboidInfo cuboidInfo, List<FragmentCuboidReader> fragmentCuboidReaders, List<DimensionEncoding[]> fragmentsDimensionEncodings, DimensionEncoding[] mergedDimEncodings, MeasureAggregators resultAggrs, ColumnarMetricsEncoding[] metricsEncodings) {
            int i;
            this.mergedDimensionEncodings = mergedDimEncodings;
            this.fragmentsDimensionEncodings = fragmentsDimensionEncodings;
            this.fragmentsRecordDecoders = Lists.newArrayList();
            for (DimensionEncoding[] fragmentDimensionEncodings : fragmentsDimensionEncodings) {
                this.fragmentsRecordDecoders.add(new RecordDecoder(fragmentDimensionEncodings));
            }
            this.fragmentsCuboidRecords = Lists.newArrayListWithCapacity(fragmentCuboidReaders.size());
            for (FragmentCuboidReader reader : fragmentCuboidReaders) {
                this.fragmentsCuboidRecords.add(reader.iterator());
            }
            this.resultAggrs = resultAggrs;
            this.metricsSerializers = new DataTypeSerializer[metricsEncodings.length];
            for (i = 0; i < metricsEncodings.length; ++i) {
                this.metricsSerializers[i] = metricsEncodings[i].asDataTypeSerializer();
            }
            this.minHeap = new PriorityQueue<Pair<DecodedRecord, Integer>>(fragmentCuboidReaders.size(), new Comparator<Pair<DecodedRecord, Integer>>(){

                @Override
                public int compare(Pair<DecodedRecord, Integer> o1, Pair<DecodedRecord, Integer> o2) {
                    return StringArrayComparator.INSTANCE.compare(o1.getFirst().dimensions, o2.getFirst().dimensions);
                }
            });
            this.oneRawRecord = new RawRecord(cuboidInfo.getDimCount(), ((FragmentFilesMerger)FragmentFilesMerger.this).parsedCubeInfo.measureCount);
            for (i = 0; i < fragmentCuboidReaders.size(); ++i) {
                this.enqueueFromFragment(i);
            }
            this.metricsBuf = ByteBuffer.allocate(this.getMaxMetricsLength());
        }

        public int getMaxMetricsLength() {
            int result = -1;
            for (int i = 0; i < this.metricsSerializers.length; ++i) {
                int maxLength = this.metricsSerializers[i].maxLength();
                if (result >= maxLength) continue;
                result = maxLength;
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            return !this.minHeap.isEmpty();
        }

        @Override
        public RawRecord next() {
            Pair<DecodedRecord, Integer> currRecordEntry = this.minHeap.poll();
            DecodedRecord currRecord = currRecordEntry.getFirst();
            this.enqueueFromFragment(currRecordEntry.getSecond());
            boolean needAggregate = false;
            boolean first = true;
            while (!this.minHeap.isEmpty() && StringArrayComparator.INSTANCE.compare(currRecord.dimensions, this.minHeap.peek().getFirst().dimensions) == 0) {
                if (first) {
                    this.doAggregate(currRecord);
                    first = false;
                    needAggregate = true;
                }
                Pair<DecodedRecord, Integer> nextRecord = this.minHeap.poll();
                this.doAggregate(nextRecord.getFirst());
                this.enqueueFromFragment(nextRecord.getSecond());
            }
            byte[][] newEncodedDimVals = this.encodeToNewDimValues(currRecord.dimensions);
            if (!needAggregate) {
                return new RawRecord(newEncodedDimVals, currRecord.metrics);
            }
            for (int i = 0; i < this.oneRawRecord.getDimensions().length; ++i) {
                this.oneRawRecord.setDimension(i, newEncodedDimVals[i]);
            }
            Object[] metricValues = new Object[((FragmentFilesMerger)FragmentFilesMerger.this).parsedCubeInfo.measureCount];
            this.resultAggrs.collectStates(metricValues);
            for (int i = 0; i < metricValues.length; ++i) {
                this.metricsBuf.clear();
                this.metricsSerializers[i].serialize(metricValues[i], this.metricsBuf);
                byte[] metricBytes = Arrays.copyOf(this.metricsBuf.array(), this.metricsBuf.position());
                this.oneRawRecord.setMetric(i, metricBytes);
            }
            this.resultAggrs.reset();
            return this.oneRawRecord;
        }

        private byte[][] encodeToNewDimValues(String[] dimensionValues) {
            byte[][] result = new byte[dimensionValues.length][];
            for (int i = 0; i < dimensionValues.length; ++i) {
                DimensionEncoding dimensionEncoding = this.mergedDimensionEncodings[i];
                byte[] bytes = new byte[dimensionEncoding.getLengthOfEncoding()];
                dimensionEncoding.encode(dimensionValues[i], bytes, 0);
                result[i] = bytes;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unSupport operation");
        }

        private void doAggregate(DecodedRecord record) {
            Object[] metricValues = new Object[((FragmentFilesMerger)FragmentFilesMerger.this).parsedCubeInfo.measureCount];
            this.decode(record.metrics, metricValues);
            this.resultAggrs.aggregate(metricValues);
        }

        public void decode(byte[][] metricsBytes, Object[] result) {
            for (int i = 0; i < this.metricsSerializers.length; ++i) {
                result[i] = this.metricsSerializers[i].deserialize(ByteBuffer.wrap(metricsBytes[i]));
            }
        }

        private void enqueueFromFragment(int index) {
            Iterator<RawRecord> fragmentCuboidRecords = this.fragmentsCuboidRecords.get(index);
            RecordDecoder recordDecoder = this.fragmentsRecordDecoders.get(index);
            if (fragmentCuboidRecords.hasNext()) {
                RawRecord rawRecord = fragmentCuboidRecords.next();
                this.minHeap.offer(new Pair<DecodedRecord, Integer>(recordDecoder.decode(rawRecord), index));
            }
        }
    }

    public class CuboidMetricDataWriter {
        private long cuboidId;
        private String metricName;
        private File tmpMetricDataFile;
        private DataOutputStream output;
        private CountingOutputStream countingOutput;
        private int maxValLen;

        public CuboidMetricDataWriter(long cuboidId, String metricName, int maxValLen) throws IOException {
            this.cuboidId = cuboidId;
            this.metricName = metricName;
            this.maxValLen = maxValLen;
            this.tmpMetricDataFile = new File(FragmentFilesMerger.this.mergeWorkingDirectory, cuboidId + "-" + metricName + ".data");
            this.countingOutput = new CountingOutputStream(new BufferedOutputStream(FileUtils.openOutputStream(this.tmpMetricDataFile)));
            this.output = new DataOutputStream(this.countingOutput);
        }

        public void write(byte[] value) throws IOException {
            this.output.writeInt(value.length);
            this.output.write(value);
        }

        public void close() throws IOException {
            this.output.close();
        }

        public int getMaxValueLen() {
            return this.maxValLen;
        }

        public long getLength() {
            return this.countingOutput.getCount();
        }

        public File getOutputFile() {
            return this.tmpMetricDataFile;
        }
    }

    public class CuboidColumnDataWriter {
        private long cuboidId;
        private String colName;
        private File tmpColDataFile;
        private CountingOutputStream output;

        public CuboidColumnDataWriter(long cuboidId, String colName) throws IOException {
            this.cuboidId = cuboidId;
            this.colName = colName;
            this.tmpColDataFile = new File(FragmentFilesMerger.this.mergeWorkingDirectory, cuboidId + "-" + colName + ".data");
            this.output = new CountingOutputStream(new BufferedOutputStream(FileUtils.openOutputStream(this.tmpColDataFile)));
        }

        public void write(byte[] value) throws IOException {
            this.output.write(value);
        }

        public void close() throws IOException {
            this.output.close();
        }

        public long getLength() {
            return this.output.getCount();
        }

        public File getOutputFile() {
            return this.tmpColDataFile;
        }
    }
}

