/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class NoCompressedColumnReader
implements ColumnDataReader {
    private ByteBuffer dataBuffer;
    private int colDataStartOffset;
    private int colValLength;
    private int rowCount;

    public NoCompressedColumnReader(ByteBuffer dataBuffer, int colDataStartOffset, int colValLength, int rowCount) {
        this.dataBuffer = dataBuffer;
        this.colDataStartOffset = colDataStartOffset;
        this.colValLength = colValLength;
        this.rowCount = rowCount;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new NoCompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        byte[] readBuffer = new byte[this.colValLength];
        this.dataBuffer.position(this.colDataStartOffset + rowNum * this.colValLength);
        this.dataBuffer.get(readBuffer);
        return readBuffer;
    }

    @Override
    public void close() throws IOException {
    }

    private class NoCompressedColumnDataItr
    implements Iterator<byte[]> {
        private int readRowCount = 0;

        public NoCompressedColumnDataItr() {
            NoCompressedColumnReader.this.dataBuffer.position(NoCompressedColumnReader.this.colDataStartOffset);
        }

        @Override
        public boolean hasNext() {
            return this.readRowCount < NoCompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] readBuffer = new byte[NoCompressedColumnReader.this.colValLength];
            NoCompressedColumnReader.this.dataBuffer.get(readBuffer);
            ++this.readRowCount;
            return readBuffer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

