/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.service;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.QueryConnection;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.server.rest.model.PrepareSqlRequest;
import org.apache.kylin.stream.server.rest.model.SQLRequest;
import org.apache.kylin.stream.server.rest.model.SQLResponse;
import org.apache.kylin.stream.server.rest.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="queryService")
public class QueryService {
    private static final Logger logger = LoggerFactory.getLogger(QueryService.class);

    private static void close(ResultSet resultSet, Statement stat, Connection conn) {
        OLAPContext.clearParameter();
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", e);
            }
        }
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("failed to close", e);
            }
        }
    }

    public SQLResponse query(SQLRequest sqlRequest) throws Exception {
        return this.queryWithSqlMassage(sqlRequest);
    }

    private SQLResponse queryWithSqlMassage(SQLRequest sqlRequest) throws Exception {
        SQLResponse fakeResponse = QueryUtil.tableauIntercept(sqlRequest.getSql());
        if (null != fakeResponse) {
            logger.debug("Return fake response, is exception? " + fakeResponse.getIsException());
            return fakeResponse;
        }
        String correctedSql = QueryUtil.massageSql(sqlRequest);
        if (!correctedSql.equals(sqlRequest.getSql())) {
            logger.info("The corrected query: " + correctedSql);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("AcceptPartialResult", String.valueOf(sqlRequest.isAcceptPartial()));
        OLAPContext.setParameters(parameters);
        return this.execute(correctedSql, sqlRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse execute(String sql, SQLRequest sqlRequest) throws Exception {
        Connection conn = null;
        Statement stat = null;
        ResultSet resultSet = null;
        ArrayList<List<String>> results = Lists.newArrayList();
        ArrayList<SelectedColumnMeta> columnMetas = Lists.newArrayList();
        try {
            conn = QueryConnection.getConnection(sqlRequest.getProject());
            if (sqlRequest instanceof PrepareSqlRequest) {
                PreparedStatement preparedState = conn.prepareStatement(sql);
                for (int i = 0; i < ((PrepareSqlRequest)sqlRequest).getParams().length; ++i) {
                    this.setParam(preparedState, i + 1, ((PrepareSqlRequest)sqlRequest).getParams()[i]);
                }
                resultSet = preparedState.executeQuery();
            } else {
                stat = conn.createStatement();
                resultSet = stat.executeQuery(sql);
            }
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getCatalogName(i), metaData.getTableName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i)));
            }
            while (resultSet.next()) {
                ArrayList<String> oneRow = Lists.newArrayListWithCapacity(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    oneRow.add(resultSet.getString(i + 1));
                }
                results.add(oneRow);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(resultSet, stat, conn);
            throw throwable;
        }
        QueryService.close(resultSet, stat, conn);
        QueryContext queryContext = QueryContextFacade.current();
        StringBuilder cubeSb = new StringBuilder();
        StringBuilder logSb = new StringBuilder("Processed rows for each storageContext: ");
        boolean isPartialResult = false;
        if (OLAPContext.getThreadLocalContexts() != null) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                String realizationName = "NULL";
                int realizationType = -1;
                if (ctx.realization != null) {
                    isPartialResult |= ctx.storageContext.isPartialResultReturned();
                    if (cubeSb.length() > 0) {
                        cubeSb.append(",");
                    }
                    cubeSb.append(ctx.realization.getCanonicalName());
                    logSb.append(ctx.storageContext.getProcessedRowCount()).append(" ");
                    realizationName = ctx.realization.getName();
                    realizationType = ctx.realization.getStorageType();
                }
                queryContext.setContextRealization(ctx.id, realizationName, realizationType);
            }
        }
        SQLResponse response = new SQLResponse(columnMetas, results, cubeSb.toString(), 0, false, null, isPartialResult);
        response.setTotalScanCount(queryContext.getScannedRows());
        return response;
    }

    private void setParam(PreparedStatement preparedState, int index, PrepareSqlRequest.StateParam param) throws SQLException {
        Class<?> clazz;
        boolean isNull = null == param.getValue();
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(clazz);
        switch (rep) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                preparedState.setString(index, isNull ? null : String.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                preparedState.setInt(index, isNull ? 0 : Integer.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                preparedState.setShort(index, isNull ? (short)0 : Short.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                preparedState.setLong(index, isNull ? 0L : Long.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                preparedState.setFloat(index, isNull ? 0.0f : Float.valueOf(param.getValue()).floatValue());
                break;
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                preparedState.setDouble(index, isNull ? 0.0 : Double.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                preparedState.setBoolean(index, !isNull && Boolean.parseBoolean(param.getValue()));
                break;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                preparedState.setByte(index, isNull ? (byte)0 : Byte.valueOf(param.getValue()));
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                preparedState.setDate(index, isNull ? null : Date.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIME: {
                preparedState.setTime(index, isNull ? null : Time.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIMESTAMP: {
                preparedState.setTimestamp(index, isNull ? null : Timestamp.valueOf(param.getValue()));
                break;
            }
            default: {
                preparedState.setObject(index, isNull ? null : param.getValue());
            }
        }
    }

    private int getInt(String content) {
        try {
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private short getShort(String content) {
        try {
            return Short.parseShort(content);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

