/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.lib.impl.hive.HiveReservoirReporter;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.apache.kylin.metrics.property.QueryCubePropertyEnum;
import org.apache.kylin.metrics.property.QueryPropertyEnum;
import org.apache.kylin.metrics.property.QueryRPCPropertyEnum;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class HiveTableCreator {
    public static void main(String[] args) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        System.out.println(HiveTableCreator.generateAllSQL(config));
    }

    public static String generateAllSQL(KylinConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append(HiveTableCreator.generateDatabaseSQL());
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQuery(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryCUBE(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryRPC(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJob(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJobException(config));
        return sb.toString();
    }

    public static String generateDatabaseSQL() {
        return "CREATE DATABASE IF NOT EXISTS " + ActiveReservoirReporter.KYLIN_PREFIX + ";\n";
    }

    public static String generateHiveTableSQL(String tableName, List<Pair<String, String>> columns, List<Pair<String, String>> partitionKVs) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS " + tableName + ";\n");
        sb.append("\n");
        sb.append("CREATE TABLE " + tableName + "\n");
        sb.append("(\n");
        for (i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Pair<String, String> column = columns.get(i);
            sb.append(column.getFirst() + " " + column.getSecond() + "\n");
        }
        sb.append(")\n");
        if (partitionKVs != null && partitionKVs.size() > 0) {
            sb.append("PARTITIONED BY(");
            for (i = 0; i < partitionKVs.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Pair<String, String> partitionKV = partitionKVs.get(i);
                sb.append(partitionKV.getFirst() + " " + partitionKV.getSecond());
            }
            sb.append(")\n");
        }
        sb.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        sb.append("STORED AS TEXTFILE;\n");
        return sb.toString();
    }

    public static String generateHiveTableSQLForMetricsQuery(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject(config.getKylinMetricsSubjectQuery());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQuery(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryCUBE(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject(config.getKylinMetricsSubjectQueryCube());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQueryCube(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryRPC(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject(config.getKylinMetricsSubjectQueryRpcCall());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQueryRPC(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJob(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject(config.getKylinMetricsSubjectJob());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJob(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJobException(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject(config.getKylinMetricsSubjectJobException());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJobException(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQuery() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(QueryPropertyEnum.ID_CODE.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.HOST.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.USER.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.PROJECT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.REALIZATION.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.REALIZATION_TYPE.toString(), HiveTypeEnum.HINT.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.TYPE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.EXCEPTION.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.TIME_COST.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.CALCITE_RETURN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.STORAGE_RETURN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryPropertyEnum.AGGR_FILTER_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQueryCube() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.HOST.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.PROJECT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.CUBE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.SEGMENT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.CUBOID_SOURCE.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.CUBOID_TARGET.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.IF_MATCH.toString(), HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.FILTER_MASK.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.IF_SUCCESS.toString(), HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.WEIGHT_PER_HIT.toString(), HiveTypeEnum.HDOUBLE.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.CALL_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.TIME_SUM.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.TIME_MAX.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.SKIP_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.SCAN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.RETURN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.AGGR_FILTER_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryCubePropertyEnum.AGGR_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQueryRPC() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.HOST.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.PROJECT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.REALIZATION.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.RPC_SERVER.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.EXCEPTION.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.CALL_TIME.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.RETURN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.SCAN_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.SKIP_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.AGGR_FILTER_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(QueryRPCPropertyEnum.AGGR_COUNT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJob() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(JobPropertyEnum.ID_CODE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.HOST.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.USER.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.PROJECT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.CUBE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.TYPE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.ALGORITHM.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.BUILD_DURATION.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.SOURCE_SIZE.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.CUBE_SIZE.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.PER_BYTES_TIME_COST.toString(), HiveTypeEnum.HDOUBLE.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.WAIT_RESOURCE_TIME.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.STEP_DURATION_DISTINCT_COLUMNS.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.STEP_DURATION_DICTIONARY.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.STEP_DURATION_INMEM_CUBING.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.STEP_DURATION_HFILE_CONVERT.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJobException() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(JobPropertyEnum.ID_CODE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.HOST.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.USER.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.PROJECT.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.CUBE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.TYPE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.ALGORITHM.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(JobPropertyEnum.EXCEPTION.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getPartitionKVsForHiveTable() {
        LinkedList<Pair<String, String>> partitionKVs = Lists.newLinkedList();
        partitionKVs.add(new Pair<String, String>(TimePropertyEnum.DAY_DATE.toString(), HiveTypeEnum.HSTRING.toString()));
        return partitionKVs;
    }

    public static List<Pair<String, String>> getTimeColumnsForMetrics() {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.add(new Pair<String, String>(RecordEvent.RecordReserveKeyEnum.TIME.toString(), HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.YEAR.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.MONTH.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.WEEK_BEGIN_DATE.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.DAY_TIME.toString(), HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.TIME_HOUR.toString(), HiveTypeEnum.HINT.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.TIME_MINUTE.toString(), HiveTypeEnum.HINT.toString()));
        columns.add(new Pair<String, String>(TimePropertyEnum.TIME_SECOND.toString(), HiveTypeEnum.HINT.toString()));
        return columns;
    }

    static enum HiveTypeEnum {
        HBOOLEAN("boolean"),
        HINT("int"),
        HBIGINT("bigint"),
        HDOUBLE("double"),
        HSTRING("string"),
        HDECIMAL("decimal");

        private final String typeName;

        private HiveTypeEnum(String typeName) {
            this.typeName = typeName;
        }

        public static HiveTypeEnum getByTypeName(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            for (HiveTypeEnum hiveType : HiveTypeEnum.values()) {
                if (!hiveType.typeName.equals(typeName.toLowerCase(Locale.ROOT))) continue;
                return hiveType;
            }
            return null;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

