/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public abstract class RelOptRuleCall {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static int nextId = 0;
    public final int id = nextId++;
    protected final RelOptRuleOperand operand0;
    protected Map<RelNode, List<RelNode>> nodeInputs;
    public final RelOptRule rule;
    public final RelNode[] rels;
    private final RelOptPlanner planner;
    private final List<RelNode> parents;

    protected RelOptRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs, List<RelNode> parents) {
        this.planner = planner;
        this.operand0 = operand;
        this.nodeInputs = nodeInputs;
        this.rule = operand.getRule();
        this.rels = rels;
        this.parents = parents;
        assert (rels.length == this.rule.operands.size());
    }

    protected RelOptRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs) {
        this(planner, operand, rels, nodeInputs, null);
    }

    public RelOptRuleOperand getOperand0() {
        return this.operand0;
    }

    public RelOptRule getRule() {
        return this.rule;
    }

    @Deprecated
    public RelNode[] getRels() {
        return this.rels;
    }

    public List<RelNode> getRelList() {
        return ImmutableList.copyOf(this.rels);
    }

    public <T extends RelNode> T rel(int ordinal) {
        return (T)this.rels[ordinal];
    }

    public List<RelNode> getChildRels(RelNode rel) {
        return this.nodeInputs.get(rel);
    }

    protected void setChildRels(RelNode rel, List<RelNode> inputs) {
        if (this.nodeInputs.isEmpty()) {
            this.nodeInputs = new HashMap<RelNode, List<RelNode>>();
        }
        this.nodeInputs.put(rel, inputs);
    }

    public RelOptPlanner getPlanner() {
        return this.planner;
    }

    public RelMetadataQuery getMetadataQuery() {
        return this.rel(0).getCluster().getMetadataQuery();
    }

    public List<RelNode> getParents() {
        return this.parents;
    }

    public abstract void transformTo(RelNode var1, Map<RelNode, RelNode> var2);

    public final void transformTo(RelNode rel) {
        this.transformTo(rel, ImmutableMap.of());
    }

    public RelBuilder builder() {
        return this.rule.relBuilderFactory.create(this.rel(0).getCluster(), null);
    }
}

