/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.mapping.AbstractTargetMapping;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class OLAPJoinPushThroughJoinRule2
extends RelOptRule {
    public static final RelOptRule INSTANCE = new OLAPJoinPushThroughJoinRule2("OLAPJoinPushThroughJoinRule2", LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    public OLAPJoinPushThroughJoinRule2(String description, Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        super(OLAPJoinPushThroughJoinRule2.operand(clazz, OLAPJoinPushThroughJoinRule2.operand(Project.class, null, new Predicate<Project>(){

            @Override
            public boolean apply(@Nullable Project input) {
                return input.getPermutation() != null;
            }
        }, OLAPJoinPushThroughJoinRule2.operand(clazz, OLAPJoinPushThroughJoinRule2.operand(RelNode.class, OLAPJoinPushThroughJoinRule2.any()), OLAPJoinPushThroughJoinRule2.operand(RelNode.class, null, new Predicate<RelNode>(){

            @Override
            public boolean apply(@Nullable RelNode input) {
                return !(input instanceof TableScan);
            }
        }, OLAPJoinPushThroughJoinRule2.any())), new RelOptRuleOperand[0]), OLAPJoinPushThroughJoinRule2.operand(TableScan.class, OLAPJoinPushThroughJoinRule2.any())), relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        this.onMatchRight(call);
    }

    private void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Project projectOnBottomJoin = (Project)call.rel(1);
        Join bottomJoin = (Join)call.rel(2);
        Object relC = call.rel(5);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        Permutation projectPermu = projectOnBottomJoin.getPermutation();
        Permutation inverseProjectPermu = projectPermu.inverse();
        Preconditions.checkNotNull(projectPermu);
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSetBelowProject = ImmutableBitSet.range(aCount, aCount + bCount);
        ImmutableBitSet bBitSetAboveProject = Mappings.apply((Mapping)inverseProjectPermu, bBitSetBelowProject);
        AbstractTargetMapping extendedProjectPerm = this.createAbstractTargetMapping(Mappings.append(projectPermu, Mappings.createIdentity(cCount)));
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule2.split(topJoin.getCondition(), bBitSetAboveProject, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule2.split(bottomJoin.getCondition(), bBitSetBelowProject, bottomIntersecting, bottomNonIntersecting);
        Preconditions.checkState(bottomNonIntersecting.isEmpty());
        Mappings.TargetMapping tempMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        Mapping thruProjectMapping = Mappings.multiply(extendedProjectPerm, this.createAbstractTargetMapping(tempMapping));
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle((Mappings.TargetMapping)thruProjectMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping nonThruProjectMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle((Mappings.TargetMapping)thruProjectMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(nonThruProjectMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(thruProjectMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project(relBuilder.fields(thruProjectMapping));
        call.transformTo(relBuilder.build());
    }

    private AbstractTargetMapping createAbstractTargetMapping(final Mappings.TargetMapping targetMapping) {
        return new AbstractTargetMapping(targetMapping.getSourceCount(), targetMapping.getTargetCount()){

            @Override
            public int getTargetOpt(int source) {
                return targetMapping.getTargetOpt(source);
            }
        };
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }
}

