/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.RefinedKetamaNodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;

public class MemcachedConnectionFactoryBuilder
extends ConnectionFactoryBuilder {
    @Override
    public ConnectionFactory build() {
        return new DefaultConnectionFactory(){

            @Override
            public BlockingQueue<Operation> createOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : MemcachedConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createReadOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : MemcachedConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            @Override
            public BlockingQueue<Operation> createWriteOperationQueue() {
                return MemcachedConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : MemcachedConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            @Override
            public NodeLocator createLocator(List<MemcachedNode> nodes) {
                switch (MemcachedConnectionFactoryBuilder.this.locator) {
                    case ARRAY_MOD: {
                        return new ArrayModNodeLocator(nodes, this.getHashAlg());
                    }
                    case CONSISTENT: {
                        return new RefinedKetamaNodeLocator(nodes, this.getHashAlg());
                    }
                }
                throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)MemcachedConnectionFactoryBuilder.this.locator));
            }

            @Override
            public Transcoder<Object> getDefaultTranscoder() {
                return MemcachedConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : MemcachedConnectionFactoryBuilder.this.transcoder;
            }

            @Override
            public FailureMode getFailureMode() {
                return MemcachedConnectionFactoryBuilder.this.failureMode == null ? super.getFailureMode() : MemcachedConnectionFactoryBuilder.this.failureMode;
            }

            @Override
            public HashAlgorithm getHashAlg() {
                return MemcachedConnectionFactoryBuilder.this.hashAlg == null ? super.getHashAlg() : MemcachedConnectionFactoryBuilder.this.hashAlg;
            }

            @Override
            public Collection<ConnectionObserver> getInitialObservers() {
                return MemcachedConnectionFactoryBuilder.this.initialObservers;
            }

            @Override
            public OperationFactory getOperationFactory() {
                return MemcachedConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : MemcachedConnectionFactoryBuilder.this.opFact;
            }

            @Override
            public long getOperationTimeout() {
                return MemcachedConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : MemcachedConnectionFactoryBuilder.this.opTimeout;
            }

            @Override
            public int getReadBufSize() {
                return MemcachedConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : MemcachedConnectionFactoryBuilder.this.readBufSize;
            }

            @Override
            public boolean isDaemon() {
                return MemcachedConnectionFactoryBuilder.this.isDaemon;
            }

            @Override
            public boolean shouldOptimize() {
                return MemcachedConnectionFactoryBuilder.this.shouldOptimize;
            }

            @Override
            public boolean useNagleAlgorithm() {
                return MemcachedConnectionFactoryBuilder.this.useNagle;
            }

            @Override
            public long getMaxReconnectDelay() {
                return MemcachedConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            @Override
            public AuthDescriptor getAuthDescriptor() {
                return MemcachedConnectionFactoryBuilder.this.authDescriptor;
            }

            @Override
            public long getOpQueueMaxBlockTime() {
                return MemcachedConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? MemcachedConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            @Override
            public int getTimeoutExceptionThreshold() {
                return MemcachedConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            @Override
            public MetricType enableMetrics() {
                return MemcachedConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : MemcachedConnectionFactoryBuilder.this.metricType;
            }

            @Override
            public MetricCollector getMetricCollector() {
                return MemcachedConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : MemcachedConnectionFactoryBuilder.this.collector;
            }

            @Override
            public ExecutorService getListenerExecutorService() {
                return MemcachedConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : MemcachedConnectionFactoryBuilder.this.executorService;
            }

            @Override
            public boolean isDefaultExecutorService() {
                return MemcachedConnectionFactoryBuilder.this.executorService == null;
            }

            @Override
            public long getAuthWaitTime() {
                return MemcachedConnectionFactoryBuilder.this.authWaitTime;
            }
        };
    }
}

