/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import java.util.Map;
import net.spy.memcached.metrics.AbstractMetricCollector;
import org.apache.kylin.job.shaded.com.codahale.metrics.Counter;
import org.apache.kylin.job.shaded.com.codahale.metrics.Histogram;
import org.apache.kylin.job.shaded.com.codahale.metrics.Meter;
import org.apache.kylin.metrics.lib.impl.MetricsSystem;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public final class MemcachedMetrics
extends AbstractMetricCollector {
    private Map<String, Counter> counters = Maps.newConcurrentMap();
    private Map<String, Meter> meters = Maps.newConcurrentMap();
    private Map<String, Histogram> histograms = Maps.newConcurrentMap();

    @Override
    public void addCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, MetricsSystem.Metrics.counter(name));
        }
    }

    @Override
    public void removeCounter(String name) {
        if (!this.counters.containsKey(name)) {
            MetricsSystem.Metrics.remove(name);
            this.counters.remove(name);
        }
    }

    @Override
    public void incrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).inc(amount);
        }
    }

    @Override
    public void decrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).dec(amount);
        }
    }

    @Override
    public void addMeter(String name) {
        if (!this.meters.containsKey(name)) {
            this.meters.put(name, MetricsSystem.Metrics.meter(name));
        }
    }

    @Override
    public void removeMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.remove(name);
        }
    }

    @Override
    public void markMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.get(name).mark();
        }
    }

    @Override
    public void addHistogram(String name) {
        if (!this.histograms.containsKey(name)) {
            this.histograms.put(name, MetricsSystem.Metrics.histogram(name));
        }
    }

    @Override
    public void removeHistogram(String name) {
        if (this.histograms.containsKey(name)) {
            this.histograms.remove(name);
        }
    }

    @Override
    public void updateHistogram(String name, int amount) {
        if (this.histograms.containsKey(name)) {
            this.histograms.get(name).update(amount);
        }
    }
}

