/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubThreadPoolExecutor
extends AbstractExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(SubThreadPoolExecutor.class);
    private final Semaphore semaphore;
    private final ExecutorService impl;
    private final String subject;

    public SubThreadPoolExecutor(ExecutorService impl, String subject, int maxThreads) {
        this.impl = impl;
        this.subject = subject;
        this.semaphore = new Semaphore(maxThreads);
    }

    private void obtainThread() {
        try {
            this.semaphore.acquire();
            logger.debug("Obtain thread for {}", (Object)this.subject);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void releaseThread() {
        this.semaphore.release();
        logger.debug("Release thread for {}", (Object)this.subject);
    }

    @Override
    public void execute(Runnable command) {
        this.obtainThread();
        this.impl.execute(command);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        ListenableFutureTask ret = this.impl instanceof SubThreadPoolExecutor ? (ListenableFutureTask)((SubThreadPoolExecutor)this.impl).newTaskFor(runnable, value) : ListenableFutureTask.create(runnable, value);
        ret.addListener(new Runnable(){

            @Override
            public void run() {
                SubThreadPoolExecutor.this.releaseThread();
            }
        }, MoreExecutors.sameThreadExecutor());
        return ret;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        ListenableFutureTask ret = this.impl instanceof SubThreadPoolExecutor ? (ListenableFutureTask)((SubThreadPoolExecutor)this.impl).newTaskFor(callable) : ListenableFutureTask.create(callable);
        ret.addListener(new Runnable(){

            @Override
            public void run() {
                SubThreadPoolExecutor.this.releaseThread();
            }
        }, MoreExecutors.sameThreadExecutor());
        return ret;
    }

    @Override
    public void shutdown() {
        throw new IllegalStateException("Manual shutdown not supported - SubThreadPoolExecutor is dependent on an external lifecycle");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException("Manual shutdown not supported - SubThreadPoolExecutor is dependent on an external lifecycle");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException("Manual shutdown not supported - SubThreadPoolExecutor is dependent on an external lifecycle");
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }
}

