/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class CuboidStatsUtil {
    private CuboidStatsUtil() {
        throw new IllegalStateException("Class CuboidStatsUtil is an utility class !");
    }

    public static Map<Long, Double> calculateCuboidHitProbability(Set<Long> selectionCuboidSet, Map<Long, Long> hitFrequencyMap, long nTotalCuboids, double queryUncertaintyRatio) {
        HashMap<Long, Double> cuboidHitProbabilityMap = Maps.newHashMapWithExpectedSize(selectionCuboidSet.size());
        if (hitFrequencyMap == null || hitFrequencyMap.isEmpty()) {
            for (Long cuboid : selectionCuboidSet) {
                cuboidHitProbabilityMap.put(cuboid, 1.0 / (double)nTotalCuboids);
            }
        } else {
            long totalHitFrequency = 0L;
            for (Map.Entry<Long, Long> hitFrequency : hitFrequencyMap.entrySet()) {
                totalHitFrequency += hitFrequency.getValue().longValue();
            }
            double unitUncertainProb = queryUncertaintyRatio / (double)nTotalCuboids;
            for (Long cuboid : selectionCuboidSet) {
                if (hitFrequencyMap.get(cuboid) != null) {
                    if (totalHitFrequency != 0L) {
                        cuboidHitProbabilityMap.put(cuboid, unitUncertainProb + (1.0 - queryUncertaintyRatio) * (double)hitFrequencyMap.get(cuboid).longValue() / (double)totalHitFrequency);
                        continue;
                    }
                    throw new ArithmeticException("/ by zero");
                }
                cuboidHitProbabilityMap.put(cuboid, unitUncertainProb);
            }
        }
        return cuboidHitProbabilityMap;
    }

    public static Map<Long, Long> generateSourceCuboidStats(Map<Long, Long> statistics, Map<Long, Double> cuboidHitProbabilityMap, Map<Long, Map<Long, Pair<Long, Long>>> rollingUpSourceMap) {
        HashMap<Long, Long> srcCuboidsStats = Maps.newHashMap();
        if (cuboidHitProbabilityMap == null || cuboidHitProbabilityMap.isEmpty() || rollingUpSourceMap == null || rollingUpSourceMap.isEmpty()) {
            return srcCuboidsStats;
        }
        for (Long cuboid : cuboidHitProbabilityMap.keySet()) {
            Map<Long, Pair<Long, Long>> innerRollingUpTargetMap;
            if (statistics.get(cuboid) != null || (innerRollingUpTargetMap = rollingUpSourceMap.get(cuboid)) == null || innerRollingUpTargetMap.isEmpty()) continue;
            long totalEstRowCount = 0L;
            int nEffective = 0;
            boolean ifHasStats = false;
            for (Long tgtCuboid : innerRollingUpTargetMap.keySet()) {
                Pair<Long, Long> rollingupStats = innerRollingUpTargetMap.get(tgtCuboid);
                if (statistics.get(tgtCuboid) != null) {
                    if (!ifHasStats) {
                        totalEstRowCount = 0L;
                        nEffective = 0;
                        ifHasStats = true;
                    }
                    double rollupRatio = CuboidStatsUtil.calculateRollupRatio(rollingupStats);
                    totalEstRowCount = (long)((double)totalEstRowCount + (1.0 - rollupRatio) * (double)statistics.get(tgtCuboid).longValue());
                    ++nEffective;
                    continue;
                }
                if (ifHasStats) continue;
                totalEstRowCount += rollingupStats.getSecond().longValue();
                ++nEffective;
            }
            if (nEffective != 0) {
                srcCuboidsStats.put(cuboid, totalEstRowCount / (long)nEffective);
                continue;
            }
            throw new ArithmeticException("/ by zero");
        }
        srcCuboidsStats.remove(0L);
        CuboidStatsUtil.adjustCuboidStats(srcCuboidsStats, statistics);
        return srcCuboidsStats;
    }

    public static Map<Long, Long> complementRowCountForCuboids(Map<Long, Long> statistics, Set<Long> cuboids) {
        HashMap<Long, Long> result = Maps.newHashMapWithExpectedSize(cuboids.size());
        TreeSet<Map.Entry<Long, Long>> sortedStatsSet = new TreeSet<Map.Entry<Long, Long>>(new Comparator<Map.Entry<Long, Long>>(){

            @Override
            public int compare(Map.Entry<Long, Long> o1, Map.Entry<Long, Long> o2) {
                int ret = o1.getValue().compareTo(o2.getValue());
                return ret == 0 ? o1.getKey().compareTo(o2.getKey()) : ret;
            }
        });
        for (Map.Entry<Long, Long> entry : statistics.entrySet()) {
            sortedStatsSet.add(entry);
        }
        block1: for (Long cuboid : cuboids) {
            if (statistics.get(cuboid) == null) {
                for (Map.Entry entry : sortedStatsSet) {
                    if (!CuboidStatsUtil.isDescendant(cuboid, (Long)entry.getKey())) continue;
                    result.put(cuboid, (Long)entry.getValue());
                    continue block1;
                }
                continue;
            }
            result.put(cuboid, statistics.get(cuboid));
        }
        return result;
    }

    public static Map<Long, Long> adjustCuboidStats(Map<Long, Long> statistics) {
        HashMap<Long, Long> ret = Maps.newHashMapWithExpectedSize(statistics.size());
        ArrayList<Long> cuboids = Lists.newArrayList(statistics.keySet());
        Collections.sort(cuboids);
        for (Long cuboid : cuboids) {
            Long rowCount = statistics.get(cuboid);
            for (Long childCuboid : ret.keySet()) {
                if (!CuboidStatsUtil.isDescendant(childCuboid, cuboid)) continue;
                Long childRowCount = (Long)ret.get(childCuboid);
                if (rowCount >= childRowCount) continue;
                rowCount = childRowCount;
            }
            ret.put(cuboid, rowCount);
        }
        return ret;
    }

    public static void adjustCuboidStats(Map<Long, Long> mandatoryCuboidsWithStats, Map<Long, Long> statistics) {
        ArrayList<Long> mandatoryCuboids = Lists.newArrayList(mandatoryCuboidsWithStats.keySet());
        Collections.sort(mandatoryCuboids);
        ArrayList<Long> selectedCuboids = Lists.newArrayList(statistics.keySet());
        Collections.sort(selectedCuboids);
        for (int i = 0; i < mandatoryCuboids.size(); ++i) {
            Long sCuboid;
            int k;
            Long mCuboid = (Long)mandatoryCuboids.get(i);
            if (statistics.get(mCuboid) != null) {
                mandatoryCuboidsWithStats.put(mCuboid, statistics.get(mCuboid));
                continue;
            }
            for (k = 0; k < selectedCuboids.size() && (sCuboid = (Long)selectedCuboids.get(k)) <= mCuboid; ++k) {
                Long childRowCount;
                if (!CuboidStatsUtil.isDescendant(sCuboid, mCuboid) || (childRowCount = statistics.get(sCuboid)) <= mandatoryCuboidsWithStats.get(mCuboid)) continue;
                mandatoryCuboidsWithStats.put(mCuboid, childRowCount);
            }
            for (int j = 0; j < i; ++j) {
                Long childRowCount;
                Long cCuboid = (Long)mandatoryCuboids.get(j);
                if (!CuboidStatsUtil.isDescendant(cCuboid, mCuboid) || (childRowCount = mandatoryCuboidsWithStats.get(cCuboid)) <= mandatoryCuboidsWithStats.get(mCuboid)) continue;
                mandatoryCuboidsWithStats.put(mCuboid, childRowCount);
            }
            while (k < selectedCuboids.size()) {
                Long parentRowCount;
                Long sCuboid2 = (Long)selectedCuboids.get(k);
                if (CuboidStatsUtil.isDescendant(mCuboid, sCuboid2) && (parentRowCount = statistics.get(sCuboid2)) < mandatoryCuboidsWithStats.get(mCuboid)) {
                    mandatoryCuboidsWithStats.put(mCuboid, parentRowCount);
                }
                ++k;
            }
        }
    }

    public static Map<Long, List<Long>> createDirectChildrenCache(Set<Long> cuboidSet) {
        final ArrayList<Long> cuboidList = Lists.newArrayList(cuboidSet);
        Collections.sort(cuboidList);
        ArrayList<Integer> layerIdxList = Lists.newArrayListWithExpectedSize(cuboidList.size());
        for (int i = 0; i < cuboidList.size(); ++i) {
            layerIdxList.add(i);
        }
        Collections.sort(layerIdxList, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                Long o1 = (Long)cuboidList.get(i1);
                Long o2 = (Long)cuboidList.get(i2);
                int nBitDiff = Long.bitCount(o1) - Long.bitCount(o2);
                if (nBitDiff != 0) {
                    return nBitDiff;
                }
                return Long.compare(o1, o2);
            }
        });
        int[] toLayerIdxArray = new int[layerIdxList.size()];
        ArrayList layerCuboidList = Lists.newArrayListWithExpectedSize(cuboidList.size());
        int i = 0;
        while (i < layerIdxList.size()) {
            int cuboidIdx = (Integer)layerIdxList.get(i);
            toLayerIdxArray[cuboidIdx] = i++;
            layerCuboidList.add(cuboidList.get(cuboidIdx));
        }
        int[] previousLayerLastIdxArray = new int[layerIdxList.size()];
        int currentBitCount = 0;
        int previousLayerLastIdx = -1;
        for (int i2 = 0; i2 < layerIdxList.size(); ++i2) {
            int cuboidIdx = (Integer)layerIdxList.get(i2);
            int nBits = Long.bitCount((Long)cuboidList.get(cuboidIdx));
            if (nBits > currentBitCount) {
                currentBitCount = nBits;
                previousLayerLastIdx = i2 - 1;
            }
            previousLayerLastIdxArray[i2] = previousLayerLastIdx;
        }
        HashMap<Long, List<Long>> directChildrenCache = Maps.newHashMap();
        for (int i3 = 0; i3 < cuboidList.size(); ++i3) {
            int j;
            Long currentCuboid = (Long)cuboidList.get(i3);
            LinkedList<Long> directChildren = Lists.newLinkedList();
            int lastLayerIdx = previousLayerLastIdxArray[toLayerIdxArray[i3]];
            if (i3 - 1 <= lastLayerIdx) {
                for (j = i3 - 1; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (Long)cuboidList.get(j));
                }
            } else {
                for (j = lastLayerIdx; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (Long)layerCuboidList.get(j));
                }
            }
            directChildrenCache.put(currentCuboid, directChildren);
        }
        return directChildrenCache;
    }

    private static void checkAndAddDirectChild(List<Long> directChildren, Long currentCuboid, Long checkedCuboid) {
        if (CuboidStatsUtil.isDescendant(checkedCuboid, currentCuboid)) {
            boolean ifDirectChild = true;
            for (long directChild : directChildren) {
                if (!CuboidStatsUtil.isDescendant(checkedCuboid, directChild)) continue;
                ifDirectChild = false;
                break;
            }
            if (ifDirectChild) {
                directChildren.add(checkedCuboid);
            }
        }
    }

    public static boolean isDescendant(long cuboidToCheck, long parentCuboid) {
        return (cuboidToCheck & parentCuboid) == cuboidToCheck;
    }

    private static double calculateRollupRatio(Pair<Long, Long> rollupStats) {
        double rollupInputCount = (double)rollupStats.getFirst().longValue() + (double)rollupStats.getSecond().longValue();
        return rollupInputCount == 0.0 ? 0.0 : 1.0 * (double)rollupStats.getFirst().longValue() / rollupInputCount;
    }
}

