/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public abstract class ComparatorEx<T>
implements Comparator<T> {
    public T min(Collection<T> v) {
        if (v.size() <= 0) {
            return null;
        }
        Iterator<T> iterator = v.iterator();
        T min = iterator.next();
        while (iterator.hasNext()) {
            min = this.min(min, iterator.next());
        }
        return min;
    }

    public T max(Collection<T> v) {
        if (v.size() <= 0) {
            return null;
        }
        Iterator<T> iterator = v.iterator();
        T max = iterator.next();
        while (iterator.hasNext()) {
            max = this.max(max, iterator.next());
        }
        return max;
    }

    public T min(T a, T b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    public T max(T a, T b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public boolean between(T v, T start, T end) {
        return this.compare(start, v) <= 0 && this.compare(v, end) <= 0;
    }
}

