/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.cube.model.validation.rule.AggregationGroupRule;
import org.apache.kylin.cube.model.validation.rule.DictionaryRule;
import org.apache.kylin.cube.model.validation.rule.FunctionRule;
import org.apache.kylin.cube.model.validation.rule.RowKeyAttrRule;
import org.apache.kylin.cube.model.validation.rule.StreamingCubeRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetadataValidator {
    protected static final Logger logger = LoggerFactory.getLogger(CubeMetadataValidator.class);
    private IValidatorRule<CubeDesc>[] defaultRules = new IValidatorRule[]{new FunctionRule(), new AggregationGroupRule(), new RowKeyAttrRule(), new DictionaryRule(), new StreamingCubeRule()};
    private List<IValidatorRule<CubeDesc>> rules = new ArrayList<IValidatorRule<CubeDesc>>(Arrays.asList(this.defaultRules));

    public CubeMetadataValidator(KylinConfig config) {
        for (String ruleName : config.getCubeMetadataExtraValidators()) {
            try {
                IValidatorRule rule = (IValidatorRule)Class.forName(ruleName).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.rules.add(rule);
            }
            catch (Exception e) {
                logger.error("Construct cube metadata validator rule: {} failed. Ignore this rule", (Object)ruleName, (Object)e);
            }
        }
    }

    public ValidateContext validate(CubeDesc cube) {
        ValidateContext context = new ValidateContext();
        for (IValidatorRule<CubeDesc> rule : this.rules) {
            rule.validate(cube, context);
        }
        for (ValidateContext.Result result : context.getResults()) {
            cube.addError((Object)((Object)result.getLevel()) + " : " + result.getMessage());
        }
        return context;
    }
}

