/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.flink.FlinkUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMergingDictionary
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(FlinkMergingDictionary.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_MERGE_SEGMENT_IDS;
    public static final Option OPTION_OUTPUT_PATH_DICT;
    public static final Option OPTION_OUTPUT_PATH_STAT;
    public static final Option OPTION_ENABLE_OBJECT_REUSE;
    private Options options = new Options();

    public FlinkMergingDictionary() {
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_MERGE_SEGMENT_IDS);
        this.options.addOption(OPTION_OUTPUT_PATH_DICT);
        this.options.addOption(OPTION_OUTPUT_PATH_STAT);
        this.options.addOption(OPTION_ENABLE_OBJECT_REUSE);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String segmentIds = optionsHelper.getOptionValue(OPTION_MERGE_SEGMENT_IDS);
        String dictOutputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH_DICT);
        String statOutputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH_STAT);
        String enableObjectReuseOptValue = optionsHelper.getOptionValue(OPTION_ENABLE_OBJECT_REUSE);
        boolean enableObjectReuse = false;
        if (enableObjectReuseOptValue != null && !enableObjectReuseOptValue.isEmpty()) {
            enableObjectReuse = true;
        }
        Job job = Job.getInstance();
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (enableObjectReuse) {
            env.getConfig().enableObjectReuse();
        }
        HadoopUtil.deletePath(job.getConfiguration(), new Path(dictOutputPath));
        SerializableConfiguration sConf = new SerializableConfiguration(job.getConfiguration());
        KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
        CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(cubeName);
        CubeDesc cubeDesc = CubeDescManager.getInstance(envConfig).getCubeDesc(cubeInstance.getDescName());
        logger.info("Dictionary output path: {}", (Object)dictOutputPath);
        logger.info("Statistics output path: {}", (Object)statOutputPath);
        TblColRef[] tblColRefs = cubeDesc.getAllColumnsNeedDictionaryBuilt().toArray(new TblColRef[0]);
        int columnLength = tblColRefs.length;
        ArrayList<Integer> indexs = Lists.newArrayListWithCapacity(columnLength);
        for (int i = 0; i <= columnLength; ++i) {
            indexs.add(i);
        }
        DataSource indexDS = env.fromCollection(indexs);
        MapOperator colToDictPathDS = indexDS.map((MapFunction)new MergeDictAndStatsFunction(cubeName, metaUrl, segmentId, StringUtil.splitByComma(segmentIds), statOutputPath, tblColRefs, sConf));
        FlinkUtil.setHadoopConfForCuboid(job, null, null);
        HadoopOutputFormat hadoopOF = new HadoopOutputFormat(new SequenceFileOutputFormat(), job);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(dictOutputPath));
        colToDictPathDS.output(hadoopOF).setParallelism(1);
        env.execute("Merge dictionary for cube:" + cubeName + ", segment " + segmentId);
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segmentId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"segmentIds");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Merging Cube Segment Ids");
        OPTION_MERGE_SEGMENT_IDS = OptionBuilder.create((String)"segmentIds");
        OptionBuilder.withArgName((String)"dictOutputPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"merged dictionary resource path");
        OPTION_OUTPUT_PATH_DICT = OptionBuilder.create((String)"dictOutputPath");
        OptionBuilder.withArgName((String)"statOutputPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"merged statistics resource path");
        OPTION_OUTPUT_PATH_STAT = OptionBuilder.create((String)"statOutputPath");
        OptionBuilder.withArgName((String)"enableObjectReuse");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Enable object reuse");
        OPTION_ENABLE_OBJECT_REUSE = OptionBuilder.create((String)"enableObjectReuse");
    }

    public static class MergeDictAndStatsFunction
    extends RichMapFunction<Integer, Tuple2<Text, Text>> {
        private String cubeName;
        private String metaUrl;
        private String segmentId;
        private String[] segmentIds;
        private String statOutputPath;
        private TblColRef[] tblColRefs;
        private SerializableConfiguration conf;
        private transient DictionaryManager dictMgr;
        private KylinConfig kylinConfig;
        private List<CubeSegment> mergingSegments;

        public MergeDictAndStatsFunction(String cubeName, String metaUrl, String segmentId, String[] segmentIds, String statOutputPath, TblColRef[] tblColRefs, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.metaUrl = metaUrl;
            this.segmentId = segmentId;
            this.segmentIds = segmentIds;
            this.statOutputPath = statOutputPath;
            this.tblColRefs = tblColRefs;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            this.kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.kylinConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(this.kylinConfig).getCube(this.cubeName);
                this.dictMgr = DictionaryManager.getInstance(this.kylinConfig);
                this.mergingSegments = this.getMergingSegments(cubeInstance, this.segmentIds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Tuple2<Text, Text> map(Integer index) throws Exception {
            if (index < this.tblColRefs.length) {
                TblColRef col = this.tblColRefs[index];
                ArrayList<DictionaryInfo> dictInfos = Lists.newArrayList();
                try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.kylinConfig);){
                    for (CubeSegment segment : this.mergingSegments) {
                        DictionaryInfo dictInfo;
                        if (segment.getDictResPath(col) == null || (dictInfo = this.dictMgr.getDictionaryInfo(segment.getDictResPath(col))) == null || dictInfos.contains(dictInfo)) continue;
                        dictInfos.add(dictInfo);
                    }
                    DictionaryInfo mergedDictInfo = this.dictMgr.mergeDictionary(dictInfos);
                    String tblCol = col.getTableAlias() + ":" + col.getName();
                    String dictInfoPath = mergedDictInfo == null ? "" : mergedDictInfo.getResourcePath();
                    Tuple2 tuple2 = new Tuple2((Object)new Text(tblCol), (Object)new Text(dictInfoPath));
                    return tuple2;
                }
            }
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(this.kylinConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(this.kylinConfig).getCube(this.cubeName);
                CubeSegment newSegment = cubeInstance.getSegmentById(this.segmentId);
                ResourceStore rs = ResourceStore.getStore(this.kylinConfig);
                HashMap<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();
                org.apache.hadoop.conf.Configuration conf = null;
                int averageSamplingPercentage = 0;
                for (CubeSegment cubeSegment : this.mergingSegments) {
                    String filePath = cubeSegment.getStatisticsResourcePath();
                    File tempFile = File.createTempFile(this.segmentId, ".seq");
                    try (InputStream is = rs.getResource(filePath).content();
                         FileOutputStream tempFileStream = new FileOutputStream(tempFile);){
                        org.apache.commons.io.IOUtils.copy((InputStream)is, (OutputStream)tempFileStream);
                    }
                    FileSystem fs = HadoopUtil.getFileSystem("file:///" + tempFile.getAbsolutePath());
                    conf = HadoopUtil.getCurrentConfiguration();
                    SequenceFile.Reader reader = new SequenceFile.Reader(fs, new Path(tempFile.getAbsolutePath()), conf);
                    Throwable throwable = null;
                    try {
                        LongWritable key = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (org.apache.hadoop.conf.Configuration)conf);
                        BytesWritable value = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (org.apache.hadoop.conf.Configuration)conf);
                        while (reader.next((Writable)key, (Writable)value)) {
                            if (key.get() == 0L) {
                                averageSamplingPercentage += Bytes.toInt(value.getBytes());
                                continue;
                            }
                            if (key.get() <= 0L) continue;
                            HLLCounter hll = new HLLCounter(this.kylinConfig.getCubeStatsHLLPrecision());
                            ByteArray byteArray = new ByteArray(value.getBytes());
                            hll.readRegisters(byteArray.asBuffer());
                            if (cuboidHLLMap.get(key.get()) != null) {
                                ((HLLCounter)cuboidHLLMap.get(key.get())).merge(hll);
                                continue;
                            }
                            cuboidHLLMap.put(key.get(), hll);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                CubeStatsWriter.writeCuboidStatistics(conf, new Path(this.statOutputPath), cuboidHLLMap, averageSamplingPercentage /= this.mergingSegments.size());
                Path statisticsFilePath = new Path(this.statOutputPath, "cuboid_statistics.seq");
                FileSystem fs = HadoopUtil.getFileSystem(statisticsFilePath, conf);
                FSDataInputStream fis = fs.open(statisticsFilePath);
                try {
                    String statisticsFileName = newSegment.getStatisticsResourcePath();
                    rs.putResource(statisticsFileName, (InputStream)fis, System.currentTimeMillis());
                }
                finally {
                    IOUtils.closeStream((Closeable)fis);
                }
                Tuple2 tuple2 = new Tuple2((Object)new Text(""), (Object)new Text(""));
                return tuple2;
            }
        }

        private List<CubeSegment> getMergingSegments(CubeInstance cube, String[] segmentIds) {
            ArrayList<CubeSegment> result = Lists.newArrayListWithCapacity(segmentIds.length);
            for (String id : segmentIds) {
                result.add(cube.getSegmentById(id));
            }
            return result;
        }
    }
}

