/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.ExtractDictionaryFromGlobalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractDictionaryFromGlobalJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(ExtractDictionaryFromGlobalJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String job_id = this.getOptionValue(OPTION_CUBING_JOB_ID);
            this.job.getConfiguration().set("cubingJobId", job_id);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            logger.info("Starting: " + this.job.getJobName());
            this.job.getConfiguration().set("mapreduce.map.speculative", "false");
            this.setJobClasspath(this.job, cube.getConfig());
            this.job.setMapperClass(ExtractDictionaryFromGlobalMapper.class);
            this.job.setNumReduceTasks(0);
            IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(segment).getFlatTableInputFormat();
            flatTableInputFormat.configureJob(this.job);
            LazyOutputFormat.setOutputFormatClass((Job)this.job, SequenceFileOutputFormat.class);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.deletePath(this.job.getConfiguration(), output);
            this.attachSegmentMetadataWithDict(segment, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }
}

