/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducerMapping;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactDistinctColumnPartitioner
extends Partitioner<SelfDefineSortableKey, Text>
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(FactDistinctColumnPartitioner.class);
    private Configuration conf;
    private FactDistinctColumnsReducerMapping reducerMapping;

    public void setConf(Configuration conf) {
        KylinConfig config;
        this.conf = conf;
        try {
            config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String cubeName = conf.get("cube.name");
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        this.reducerMapping = new FactDistinctColumnsReducerMapping(cube);
    }

    public int getPartition(SelfDefineSortableKey skey, Text value, int numReduceTasks) {
        Text key = skey.getText();
        if (key.getBytes()[0] == -1) {
            Long cuboidId = Bytes.toLong(key.getBytes(), 1, 8);
            return this.reducerMapping.getReducerIdForCuboidRowCount(cuboidId);
        }
        return BytesUtil.readUnsigned(key.getBytes(), 0, 1);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

