/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public class FilterRecommendCuboidDataMapper
extends KylinMapper<Text, Text, Text, Text> {
    private boolean enableSharding;
    private long baseCuboid;
    private Set<Long> recommendCuboids;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        String cubeName = context.getConfiguration().get("cube.name");
        String segmentID = context.getConfiguration().get("cube.segment.id");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance cube = cubeManager.getCube(cubeName);
        CubeSegment optSegment = cube.getSegmentById(segmentID);
        CubeSegment originalSegment = cube.getOriginalSegmentToOptimize(optSegment);
        this.enableSharding = originalSegment.isEnableSharding();
        this.baseCuboid = cube.getCuboidScheduler().getBaseCuboidId();
        this.recommendCuboids = cube.getCuboidsRecommend();
        Preconditions.checkNotNull(this.recommendCuboids, "The recommend cuboid map could not be null");
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        long cuboidID = RowKeySplitter.getCuboidId(key.getBytes(), this.enableSharding);
        if (cuboidID != this.baseCuboid && !this.recommendCuboids.contains(cuboidID)) {
            return;
        }
        context.write((Object)key, (Object)value);
    }
}

