/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UHCDictionaryMapper
extends KylinMapper<NullWritable, Text, SelfDefineSortableKey, NullWritable> {
    private static final Logger logger = LoggerFactory.getLogger(UHCDictionaryMapper.class);
    protected int index;
    protected DataType type;
    protected Text outputKey = new Text();
    private ByteBuffer tmpBuf;
    private SelfDefineSortableKey sortableKey = new SelfDefineSortableKey();

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        this.tmpBuf = ByteBuffer.allocate(4096);
        Configuration conf = context.getConfiguration();
        this.bindCurrentConfiguration(conf);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeInstance cube = CubeManager.getInstance(config).getCube(conf.get("cube.name"));
        List<TblColRef> uhcColumns = cube.getDescriptor().getAllUHCColumns();
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        String colName = fileSplit.getPath().getParent().getName();
        for (int i = 0; i < uhcColumns.size(); ++i) {
            if (!uhcColumns.get(i).getIdentity().equalsIgnoreCase(colName)) continue;
            this.index = i;
            break;
        }
        this.type = uhcColumns.get(this.index).getType();
        logger.info("column name: " + colName);
        logger.info("index: " + this.index);
        logger.info("type: " + this.type);
    }

    @Override
    public void doMap(NullWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.tmpBuf.clear();
        int size = value.getLength() + 1;
        if (size >= this.tmpBuf.capacity()) {
            this.tmpBuf = ByteBuffer.allocate(this.countNewSize(this.tmpBuf.capacity(), size));
        }
        this.tmpBuf.put(Bytes.toBytes(this.index)[3]);
        this.tmpBuf.put(value.getBytes(), 0, value.getLength());
        this.outputKey.set(this.tmpBuf.array(), 0, this.tmpBuf.position());
        this.sortableKey.init(this.outputKey, this.type);
        context.write((Object)this.sortableKey, (Object)NullWritable.get());
    }

    private int countNewSize(int oldSize, int dataSize) {
        int newSize;
        for (newSize = oldSize * 2; newSize < dataSize; newSize *= 2) {
        }
        return newSize;
    }
}

