/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.storage.columnar.FragmentId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnarSplitInputFormat
extends FileInputFormat {
    private static final Logger logger = LoggerFactory.getLogger(ColumnarSplitInputFormat.class);

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        Path[] dirs = ColumnarSplitInputFormat.getInputPaths((JobContext)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])dirs, (Configuration)job.getConfiguration());
        ArrayList<FileStatus> result = Lists.newArrayList();
        for (int i = 0; i < dirs.length; ++i) {
            Path p = dirs[i];
            FileSystem fs = p.getFileSystem(job.getConfiguration());
            FileStatus[] groups = fs.listStatus(p, new PathFilter(){

                public boolean accept(Path path) {
                    String groupName = path.getName();
                    String groupNameRegex = "\\d+";
                    return groupName.matches(groupNameRegex);
                }
            });
            for (int j = 0; j < groups.length; ++j) {
                FileStatus[] nodes;
                for (FileStatus node : nodes = fs.listStatus(groups[j].getPath(), new PathFilter(){

                    public boolean accept(Path path) {
                        String nodeName = path.getName();
                        try {
                            FragmentId.parse(nodeName);
                            return true;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                })) {
                    if (this.isValidFragmentPath(fs, node.getPath())) {
                        result.add(node);
                        continue;
                    }
                    logger.warn("Invalid fragment path:" + node.getPath());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (FileStatus fileStatus : result) {
                sb.append(fileStatus.getPath());
                sb.append(",  ");
            }
            logger.debug("Mapper splits are: " + sb.toString());
        }
        logger.info("Total input paths to process : " + result.size());
        return result;
    }

    private boolean isValidFragmentPath(FileSystem fs, Path path) throws IOException {
        RemoteIterator files = fs.listFiles(path, false);
        if (files == null) {
            logger.warn("Invalid fragment path:{}, empty folder", (Object)path);
            return false;
        }
        boolean hasDataFile = false;
        boolean hasMetaFile = false;
        while (files.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)files.next();
            Path childPath = fileStatus.getPath();
            String name = childPath.getName();
            if (name.endsWith(".data")) {
                hasDataFile = true;
                continue;
            }
            if (name.endsWith(".meta")) {
                hasMetaFile = true;
                continue;
            }
            logger.warn("Contains invalid file {} in path {}", (Object)childPath, (Object)path);
        }
        if (hasDataFile && hasMetaFile) {
            return true;
        }
        logger.warn("Invalid fragment path:{}, data file exists:{}, meta file exists:{}", path, hasDataFile, hasMetaFile);
        return false;
    }
}

