/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.percentile.PercentileCounter;

public class PercentileCounterSerializer
extends Serializer<PercentileCounter> {
    public void write(Kryo kryo, Output output, PercentileCounter counter) {
        int length = counter.getRegisters().byteSize();
        ByteBuffer buffer = ByteBuffer.allocate(length);
        counter.getRegisters().asSmallBytes(buffer);
        output.writeDouble(counter.getCompression());
        output.writeDouble(counter.getQuantileRatio());
        output.writeInt(buffer.position());
        output.write(buffer.array(), 0, buffer.position());
    }

    public PercentileCounter read(Kryo kryo, Input input, Class type) {
        int bytesRead;
        double compression = input.readDouble();
        double quantileRatio = input.readDouble();
        int length = input.readInt();
        byte[] buffer = new byte[length];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, buffer.length - offset)) != -1 && (offset += bytesRead) < buffer.length) {
        }
        PercentileCounter counter = new PercentileCounter(compression, quantileRatio);
        counter.readRegisters(ByteBuffer.wrap(buffer));
        return counter;
    }
}

