/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.impl.threadpool.DefaultFetcherRunner;
import org.apache.kylin.job.impl.threadpool.FetcherRunner;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.job.impl.threadpool.JobExecutor;
import org.apache.kylin.job.impl.threadpool.PriorityFetcherRunner;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduler
implements Scheduler<AbstractExecutable> {
    private static DefaultScheduler INSTANCE;
    private JobLock jobLock;
    private FetcherRunner fetcher;
    private ScheduledExecutorService fetcherPool;
    private ExecutorService jobPool;
    private DefaultContext context;
    private static final Logger logger;
    private volatile boolean initialized = false;
    private volatile boolean hasStarted = false;
    private JobEngineConfig jobEngineConfig;

    public static synchronized DefaultScheduler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = DefaultScheduler.createInstance();
        }
        return INSTANCE;
    }

    public static synchronized DefaultScheduler createInstance() {
        DefaultScheduler.destroyInstance();
        INSTANCE = new DefaultScheduler();
        return INSTANCE;
    }

    public static synchronized void destroyInstance() {
        DefaultScheduler tmp = INSTANCE;
        INSTANCE = null;
        if (tmp != null) {
            try {
                tmp.shutdown();
            }
            catch (SchedulerException e) {
                logger.error("error stop DefaultScheduler", e);
                throw new RuntimeException(e);
            }
        }
    }

    public DefaultScheduler() {
        if (INSTANCE != null) {
            throw new IllegalStateException("DefaultScheduler has been initiated.");
        }
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance(this.jobEngineConfig.getConfig());
    }

    public FetcherRunner getFetcherRunner() {
        return this.fetcher;
    }

    @Override
    public synchronized void init(JobEngineConfig jobEngineConfig, JobLock lock) throws SchedulerException {
        this.jobLock = lock;
        if (!ServerMode.SERVER_MODE.canServeJobBuild()) {
            logger.info("server mode: " + jobEngineConfig.getConfig().getServerMode() + ", no need to run job scheduler");
            return;
        }
        logger.info("Initializing Job Engine ....");
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.jobEngineConfig = jobEngineConfig;
        if (!this.jobLock.lockJobEngine()) {
            throw new IllegalStateException("Cannot start job scheduler due to lack of job lock");
        }
        this.fetcherPool = Executors.newScheduledThreadPool(1);
        int corePoolSize = jobEngineConfig.getMaxConcurrentJobLimit();
        this.jobPool = new ThreadPoolExecutor(corePoolSize, corePoolSize, Long.MAX_VALUE, TimeUnit.DAYS, new SynchronousQueue<Runnable>());
        this.context = new DefaultContext(Maps.newConcurrentMap(), jobEngineConfig.getConfig());
        logger.info("Starting resume all running jobs.");
        ExecutableManager executableManager = this.getExecutableManager();
        executableManager.resumeAllRunningJobs();
        logger.info("Finishing resume all running jobs.");
        int pollSecond = jobEngineConfig.getPollIntervalSecond();
        logger.info("Fetching jobs every {} seconds", (Object)pollSecond);
        JobExecutor jobExecutor = new JobExecutor(){

            @Override
            public void execute(AbstractExecutable executable) {
                DefaultScheduler.this.jobPool.execute(new JobRunner(executable));
            }
        };
        this.fetcher = jobEngineConfig.getJobPriorityConsidered() ? new PriorityFetcherRunner(jobEngineConfig, this.context, jobExecutor) : new DefaultFetcherRunner(jobEngineConfig, this.context, jobExecutor);
        logger.info("Creating fetcher pool instance:" + System.identityHashCode(this.fetcher));
        this.fetcherPool.scheduleAtFixedRate(this.fetcher, pollSecond / 10, pollSecond, TimeUnit.SECONDS);
        this.hasStarted = true;
    }

    @Override
    public void shutdown() throws SchedulerException {
        logger.info("Shutting down DefaultScheduler ....");
        this.jobLock.unlockJobEngine();
        this.initialized = false;
        this.hasStarted = false;
        try {
            this.fetcherPool.shutdownNow();
            this.fetcherPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.warn("InterruptedException is caught when shutting down job fetcher.", e);
        }
        try {
            this.jobPool.shutdownNow();
            this.jobPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.warn("InterruptedException is caught when shutting down job pool.", e);
        }
    }

    @Override
    public boolean hasStarted() {
        return this.hasStarted;
    }

    static {
        logger = LoggerFactory.getLogger(DefaultScheduler.class);
    }

    private class JobRunner
    implements IJobRunner {
        private final AbstractExecutable executable;

        public JobRunner(AbstractExecutable executable) {
            this.executable = executable;
        }

        @Override
        public boolean acquireJobLock() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (SetThreadName ignored = new SetThreadName("Scheduler %s Job %s", System.identityHashCode(DefaultScheduler.this), this.executable.getId());){
                this.executable.execute(DefaultScheduler.this.context, this);
            }
            catch (ExecuteException e) {
                logger.error("ExecuteException job:" + this.executable.getId(), e);
            }
            catch (Exception e) {
                if (AbstractExecutable.isMetaDataPersistException(e, 5)) {
                    ExecutableManager.getInstance(DefaultScheduler.this.jobEngineConfig.getConfig()).forceKillJobWithRetry(this.executable.getId());
                }
                logger.error("unknown error execute job:" + this.executable.getId(), e);
            }
            finally {
                DefaultScheduler.this.context.removeRunningJob(this.executable);
            }
            DefaultScheduler.this.fetcherPool.schedule(DefaultScheduler.this.fetcher, 0L, TimeUnit.SECONDS);
        }
    }
}

