/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.com.codahale.metrics.json;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.job.shaded.com.codahale.metrics.Counter;
import org.apache.kylin.job.shaded.com.codahale.metrics.Gauge;
import org.apache.kylin.job.shaded.com.codahale.metrics.Histogram;
import org.apache.kylin.job.shaded.com.codahale.metrics.Meter;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricFilter;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.kylin.job.shaded.com.codahale.metrics.Snapshot;
import org.apache.kylin.job.shaded.com.codahale.metrics.Timer;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.Version;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.module.SimpleSerializers;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class MetricsModule
extends Module {
    static final Version VERSION = new Version(3, 0, 0, "", "org.apache.kylin.job.shaded.com.codahale.metrics", "metrics-json");
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final boolean showSamples;
    private final MetricFilter filter;

    public MetricsModule(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples) {
        this(rateUnit, durationUnit, showSamples, MetricFilter.ALL);
    }

    public MetricsModule(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples, MetricFilter filter) {
        this.rateUnit = rateUnit;
        this.durationUnit = durationUnit;
        this.showSamples = showSamples;
        this.filter = filter;
    }

    @Override
    public String getModuleName() {
        return "metrics";
    }

    @Override
    public Version version() {
        return VERSION;
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addSerializers(new SimpleSerializers(Arrays.asList(new GaugeSerializer(), new CounterSerializer(), new HistogramSerializer(this.showSamples), new MeterSerializer(this.rateUnit), new TimerSerializer(this.rateUnit, this.durationUnit, this.showSamples), new MetricRegistrySerializer(this.filter))));
    }

    private static String calculateRateUnit(TimeUnit unit, String name) {
        String s = unit.toString().toLowerCase(Locale.US);
        return name + '/' + s.substring(0, s.length() - 1);
    }

    private static class MetricRegistrySerializer
    extends StdSerializer<MetricRegistry> {
        private final MetricFilter filter;

        private MetricRegistrySerializer(MetricFilter filter) {
            super(MetricRegistry.class);
            this.filter = filter;
        }

        @Override
        public void serialize(MetricRegistry registry, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("version", VERSION.toString());
            json.writeObjectField("gauges", registry.getGauges(this.filter));
            json.writeObjectField("counters", registry.getCounters(this.filter));
            json.writeObjectField("histograms", registry.getHistograms(this.filter));
            json.writeObjectField("meters", registry.getMeters(this.filter));
            json.writeObjectField("timers", registry.getTimers(this.filter));
            json.writeEndObject();
        }
    }

    private static class TimerSerializer
    extends StdSerializer<Timer> {
        private final String rateUnit;
        private final double rateFactor;
        private final String durationUnit;
        private final double durationFactor;
        private final boolean showSamples;

        private TimerSerializer(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples) {
            super(Timer.class);
            this.rateUnit = MetricsModule.calculateRateUnit(rateUnit, "calls");
            this.rateFactor = rateUnit.toSeconds(1L);
            this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
            this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
            this.showSamples = showSamples;
        }

        @Override
        public void serialize(Timer timer, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            Snapshot snapshot = timer.getSnapshot();
            json.writeNumberField("count", timer.getCount());
            json.writeNumberField("max", (double)snapshot.getMax() * this.durationFactor);
            json.writeNumberField("mean", snapshot.getMean() * this.durationFactor);
            json.writeNumberField("min", (double)snapshot.getMin() * this.durationFactor);
            json.writeNumberField("p50", snapshot.getMedian() * this.durationFactor);
            json.writeNumberField("p75", snapshot.get75thPercentile() * this.durationFactor);
            json.writeNumberField("p95", snapshot.get95thPercentile() * this.durationFactor);
            json.writeNumberField("p98", snapshot.get98thPercentile() * this.durationFactor);
            json.writeNumberField("p99", snapshot.get99thPercentile() * this.durationFactor);
            json.writeNumberField("p999", snapshot.get999thPercentile() * this.durationFactor);
            if (this.showSamples) {
                long[] values = snapshot.getValues();
                double[] scaledValues = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    scaledValues[i] = (double)values[i] * this.durationFactor;
                }
                json.writeObjectField("values", scaledValues);
            }
            json.writeNumberField("stddev", snapshot.getStdDev() * this.durationFactor);
            json.writeNumberField("m15_rate", timer.getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", timer.getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", timer.getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", timer.getMeanRate() * this.rateFactor);
            json.writeStringField("duration_units", this.durationUnit);
            json.writeStringField("rate_units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class MeterSerializer
    extends StdSerializer<Meter> {
        private final String rateUnit;
        private final double rateFactor;

        public MeterSerializer(TimeUnit rateUnit) {
            super(Meter.class);
            this.rateFactor = rateUnit.toSeconds(1L);
            this.rateUnit = MetricsModule.calculateRateUnit(rateUnit, "events");
        }

        @Override
        public void serialize(Meter meter, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeNumberField("count", meter.getCount());
            json.writeNumberField("m15_rate", meter.getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", meter.getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", meter.getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", meter.getMeanRate() * this.rateFactor);
            json.writeStringField("units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class HistogramSerializer
    extends StdSerializer<Histogram> {
        private final boolean showSamples;

        private HistogramSerializer(boolean showSamples) {
            super(Histogram.class);
            this.showSamples = showSamples;
        }

        @Override
        public void serialize(Histogram histogram, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            Snapshot snapshot = histogram.getSnapshot();
            json.writeNumberField("count", histogram.getCount());
            json.writeNumberField("max", snapshot.getMax());
            json.writeNumberField("mean", snapshot.getMean());
            json.writeNumberField("min", snapshot.getMin());
            json.writeNumberField("p50", snapshot.getMedian());
            json.writeNumberField("p75", snapshot.get75thPercentile());
            json.writeNumberField("p95", snapshot.get95thPercentile());
            json.writeNumberField("p98", snapshot.get98thPercentile());
            json.writeNumberField("p99", snapshot.get99thPercentile());
            json.writeNumberField("p999", snapshot.get999thPercentile());
            if (this.showSamples) {
                json.writeObjectField("values", snapshot.getValues());
            }
            json.writeNumberField("stddev", snapshot.getStdDev());
            json.writeEndObject();
        }
    }

    private static class CounterSerializer
    extends StdSerializer<Counter> {
        private CounterSerializer() {
            super(Counter.class);
        }

        @Override
        public void serialize(Counter counter, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeNumberField("count", counter.getCount());
            json.writeEndObject();
        }
    }

    private static class GaugeSerializer
    extends StdSerializer<Gauge> {
        private GaugeSerializer() {
            super(Gauge.class);
        }

        @Override
        public void serialize(Gauge gauge, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            try {
                Object value = gauge.getValue();
                json.writeObjectField("value", value);
            }
            catch (RuntimeException e) {
                json.writeObjectField("error", e.toString());
            }
            json.writeEndObject();
        }
    }
}

