/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.com.tdunning.math.stats;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.kylin.job.shaded.com.tdunning.math.stats.AbstractTDigest;
import org.apache.kylin.job.shaded.com.tdunning.math.stats.Centroid;
import org.apache.kylin.job.shaded.com.tdunning.math.stats.GroupTree;
import org.apache.kylin.job.shaded.com.tdunning.math.stats.TDigest;

public class TreeDigest
extends AbstractTDigest {
    private double compression = 100.0;
    private GroupTree summary = new GroupTree();
    long count = 0L;
    public static final int VERBOSE_ENCODING = 1;
    public static final int SMALL_ENCODING = 2;

    public TreeDigest(double compression) {
        this.compression = compression;
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, this.createCentroid(x, 0));
    }

    @Override
    public void add(double x, int w, Centroid base) {
        this.checkValue(x);
        Centroid start = this.summary.floor(base);
        if (start == null) {
            start = this.summary.ceiling(base);
        }
        if (start == null) {
            this.summary.add(Centroid.createWeighted(x, w, base.data()));
            this.count = w;
        } else {
            Centroid neighbor;
            double z;
            Iterable<Centroid> neighbors = this.summary.tailSet(start);
            double minDistance = Double.MAX_VALUE;
            int lastNeighbor = 0;
            int i = 0;
            Iterator<Centroid> i$ = neighbors.iterator();
            while (i$.hasNext() && (z = Math.abs((neighbor = i$.next()).mean() - x)) <= minDistance) {
                minDistance = z;
                lastNeighbor = i++;
            }
            Centroid closest = null;
            long sum = this.summary.headSum(start);
            i = 0;
            double n = 1.0;
            for (Centroid neighbor2 : neighbors) {
                if (i > lastNeighbor) break;
                double z2 = Math.abs(neighbor2.mean() - x);
                double q = ((double)sum + (double)neighbor2.count() / 2.0) / (double)this.count;
                double k = (double)(4L * this.count) * q * (1.0 - q) / this.compression;
                if (z2 == minDistance && (double)(neighbor2.count() + w) <= k) {
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = neighbor2;
                    }
                    n += 1.0;
                }
                sum += (long)neighbor2.count();
                ++i;
            }
            if (closest == null) {
                this.summary.add(Centroid.createWeighted(x, w, base.data()));
            } else {
                this.summary.remove(closest);
                closest.add(x, w, base.data());
                this.summary.add(closest);
            }
            this.count += (long)w;
            if ((double)this.summary.size() > 20.0 * this.compression) {
                this.compress();
            }
        }
    }

    public static TDigest merge(double compression, Iterable<TDigest> subData, Random gen) {
        TreeDigest r = new TreeDigest(compression);
        return TreeDigest.merge(subData, gen, r);
    }

    @Override
    public void compress() {
        TreeDigest reduced = new TreeDigest(this.compression);
        if (this.recordAllData) {
            reduced.recordAllData();
        }
        ArrayList<Centroid> tmp = new ArrayList<Centroid>();
        for (Centroid centroid : this.summary) {
            tmp.add(centroid);
        }
        Collections.shuffle(tmp, this.gen);
        for (Centroid centroid : tmp) {
            reduced.add(centroid.mean(), centroid.count(), centroid);
        }
        this.summary = reduced.summary;
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public double cdf(double x) {
        double left;
        GroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return x < values.first().mean() ? 0.0 : 1.0;
        }
        double r = 0.0;
        Iterator<Centroid> it = values.iterator();
        Centroid a = it.next();
        Centroid b = it.next();
        double right = left = (b.mean() - a.mean()) / 2.0;
        while (it.hasNext()) {
            if (x < a.mean() + right) {
                return (r + (double)a.count() * TreeDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.count;
            }
            r += (double)a.count();
            a = b;
            b = it.next();
            left = right;
            right = (b.mean() - a.mean()) / 2.0;
        }
        left = right;
        a = b;
        if (x < a.mean() + right) {
            return (r + (double)a.count() * TreeDigest.interpolate(x, a.mean() - left, a.mean() + right)) / (double)this.count;
        }
        return 1.0;
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        GroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return values.iterator().next().mean();
        }
        double index = q * (double)(this.count - 1L);
        double previousMean = Double.NaN;
        double previousIndex = 0.0;
        long total = 0L;
        Iterator<Centroid> it = this.centroids().iterator();
        while (true) {
            Centroid next;
            double nextIndex;
            if ((nextIndex = (double)total + ((double)(next = it.next()).count() - 1.0) / 2.0) >= index) {
                if (Double.isNaN(previousMean)) {
                    if (nextIndex == previousIndex) {
                        return next.mean();
                    }
                    Centroid next2 = it.next();
                    double nextIndex2 = (double)(total + (long)next.count()) + ((double)next2.count() - 1.0) / 2.0;
                    previousMean = (nextIndex2 * next.mean() - nextIndex * next2.mean()) / (nextIndex2 - nextIndex);
                }
                return TreeDigest.quantile(index, previousIndex, nextIndex, previousMean, next.mean());
            }
            if (!it.hasNext()) {
                double nextIndex2 = this.count - 1L;
                double nextMean2 = (next.mean() * (nextIndex2 - previousIndex) - previousMean * (nextIndex2 - nextIndex)) / (nextIndex - previousIndex);
                return TreeDigest.quantile(index, nextIndex, nextIndex2, next.mean(), nextMean2);
            }
            total += (long)next.count();
            previousMean = next.mean();
            previousIndex = nextIndex;
        }
    }

    @Override
    public Collection<Centroid> centroids() {
        return Collections.unmodifiableCollection(this.summary);
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        return 16 + this.summary.size() * 12;
    }

    @Override
    public int smallByteSize() {
        int bound = this.byteSize();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        this.asSmallBytes(buf);
        return buf.position();
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        buf.putInt(1);
        buf.putDouble(this.compression());
        buf.putInt(this.summary.size());
        for (Centroid centroid : this.summary) {
            buf.putDouble(centroid.mean());
        }
        for (Centroid centroid : this.summary) {
            buf.putInt(centroid.count());
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        buf.putInt(2);
        buf.putDouble(this.compression());
        buf.putInt(this.summary.size());
        double x = 0.0;
        for (Centroid centroid : this.summary) {
            double delta = centroid.mean() - x;
            x = centroid.mean();
            buf.putFloat((float)delta);
        }
        for (Centroid centroid : this.summary) {
            int n = centroid.count();
            TreeDigest.encode(buf, n);
        }
    }

    public static TreeDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == 1) {
            int i;
            double compression = buf.getDouble();
            TreeDigest r = new TreeDigest(compression);
            int n = buf.getInt();
            double[] means = new double[n];
            for (i = 0; i < n; ++i) {
                means[i] = buf.getDouble();
            }
            for (i = 0; i < n; ++i) {
                r.add(means[i], buf.getInt());
            }
            return r;
        }
        if (encoding == 2) {
            int i;
            double compression = buf.getDouble();
            TreeDigest r = new TreeDigest(compression);
            int n = buf.getInt();
            double[] means = new double[n];
            double x = 0.0;
            for (i = 0; i < n; ++i) {
                double delta = buf.getFloat();
                means[i] = x += delta;
            }
            for (i = 0; i < n; ++i) {
                int z = TreeDigest.decode(buf);
                r.add(means[i], z);
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }
}

