/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.project.ProjectStatusEnum;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ProjectInstance
extends RootPersistentEntity
implements ISourceAware {
    public static final String DEFAULT_PROJECT_NAME = "default";
    private KylinConfigExt config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="tables")
    private Set<String> tables = new TreeSet<String>();
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="status")
    private ProjectStatusEnum status;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="last_update_time")
    private String lastUpdateTime;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="realizations")
    private List<RealizationEntry> realizationEntries;
    @JsonProperty(value="models")
    private List<String> models;
    @JsonProperty(value="ext_filters")
    private Set<String> extFilters = new TreeSet<String>();
    @JsonProperty(value="override_kylin_properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LinkedHashMap<String, String> overrideKylinProps;

    public static ProjectInstance create(String name, String owner, String description, LinkedHashMap<String, String> overrideProps, List<RealizationEntry> realizationEntries, List<String> models) {
        ProjectInstance projectInstance = new ProjectInstance();
        projectInstance.updateRandomUuid();
        projectInstance.setName(name);
        projectInstance.setOwner(owner);
        projectInstance.setDescription(description);
        projectInstance.setStatus(ProjectStatusEnum.ENABLED);
        projectInstance.setCreateTimeUTC(System.currentTimeMillis());
        projectInstance.setOverrideKylinProps(overrideProps);
        if (realizationEntries != null) {
            projectInstance.setRealizationEntries(realizationEntries);
        } else {
            projectInstance.setRealizationEntries(Lists.newArrayList());
        }
        if (models != null) {
            projectInstance.setModels(models);
        } else {
            projectInstance.setModels(new ArrayList<String>());
        }
        return projectInstance;
    }

    public void init() {
        if (this.name == null) {
            this.name = DEFAULT_PROJECT_NAME;
        }
        if (this.realizationEntries == null) {
            this.realizationEntries = new ArrayList<RealizationEntry>();
        }
        if (this.tables == null) {
            this.tables = new TreeSet<String>();
        }
        if (this.overrideKylinProps == null) {
            this.overrideKylinProps = new LinkedHashMap();
        }
        this.initConfig();
        if (StringUtils.isBlank(this.name)) {
            throw new IllegalStateException("Project name must not be blank");
        }
    }

    private void initConfig() {
        this.config = KylinConfigExt.createInstance(KylinConfig.getInstanceFromEnv(), this.overrideKylinProps);
    }

    public String getResourcePath() {
        return ProjectInstance.concatResourcePath(this.resourceName());
    }

    public static String concatResourcePath(String projectName) {
        return "/project/" + projectName + ".json";
    }

    @Override
    public String resourceName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExtFilters(Set<String> extFilters) {
        this.extFilters = extFilters;
    }

    public ProjectStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatusEnum status) {
        this.status = status;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean containsRealization(final RealizationType type, final String realization) {
        return Iterables.any(this.realizationEntries, new Predicate<RealizationEntry>(){

            @Override
            public boolean apply(RealizationEntry input) {
                return input.getType() == type && input.getRealization().equalsIgnoreCase(realization);
            }
        });
    }

    public void removeRealization(final RealizationType type, final String realization) {
        Iterables.removeIf(this.realizationEntries, new Predicate<RealizationEntry>(){

            @Override
            public boolean apply(RealizationEntry input) {
                return input.getType() == type && input.getRealization().equalsIgnoreCase(realization);
            }
        });
    }

    public List<RealizationEntry> getRealizationEntries(final RealizationType type) {
        if (type == null) {
            return this.getRealizationEntries();
        }
        return ImmutableList.copyOf(Iterables.filter(this.realizationEntries, new Predicate<RealizationEntry>(){

            @Override
            public boolean apply(@Nullable RealizationEntry input) {
                return input.getType() == type;
            }
        }));
    }

    public int getRealizationCount(final RealizationType type) {
        if (type == null) {
            return this.realizationEntries.size();
        }
        return Iterables.size(Iterables.filter(this.realizationEntries, new Predicate<RealizationEntry>(){

            @Override
            public boolean apply(RealizationEntry input) {
                return input.getType() == type;
            }
        }));
    }

    public void addRealizationEntry(RealizationType type, String realizationName) {
        RealizationEntry pdm = new RealizationEntry();
        pdm.setType(type);
        pdm.setRealization(realizationName);
        this.realizationEntries.add(pdm);
    }

    public void setTables(Set<String> tables) {
        this.tables = tables;
    }

    public boolean containsTable(String tableName) {
        return this.tables.contains(tableName.toUpperCase(Locale.ROOT));
    }

    public void removeTable(String tableName) {
        this.tables.remove(tableName.toUpperCase(Locale.ROOT));
    }

    public void addExtFilter(String extFilterName) {
        this.getExtFilters().add(extFilterName);
    }

    public void removeExtFilter(String filterName) {
        this.extFilters.remove(filterName);
    }

    public void addTable(String tableName) {
        this.tables.add(tableName.toUpperCase(Locale.ROOT));
    }

    public Set<String> getTables() {
        return this.tables;
    }

    public Set<String> getExtFilters() {
        return this.extFilters;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void recordUpdateTime(long timeMillis) {
        this.lastUpdateTime = ProjectInstance.formatTime(timeMillis);
    }

    public List<RealizationEntry> getRealizationEntries() {
        return this.realizationEntries;
    }

    public void setRealizationEntries(List<RealizationEntry> entries) {
        this.realizationEntries = entries;
    }

    public List<String> getModels() {
        return this.models;
    }

    public boolean containsModel(String modelName) {
        return this.models != null && this.models.contains(modelName);
    }

    public void setModels(List<String> models) {
        this.models = models;
    }

    public void addModel(String modelName) {
        if (this.getModels() == null) {
            this.setModels(new ArrayList<String>());
        }
        this.getModels().add(modelName);
    }

    public void removeModel(String modelName) {
        if (this.getModels() != null) {
            this.getModels().remove(modelName);
        }
    }

    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        if (overrideKylinProps == null) {
            overrideKylinProps = new LinkedHashMap();
        }
        this.overrideKylinProps = overrideKylinProps;
        this.initConfig();
    }

    @Override
    public KylinConfig getConfig() {
        return this.config;
    }

    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public String toString() {
        return "ProjectDesc [name=" + this.name + "]";
    }

    @Override
    public int getSourceType() {
        return this.getConfig().getDefaultSource();
    }
}

