/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class AggregateProjectReduceRule
extends RelOptRule {
    public static final AggregateProjectReduceRule INSTANCE = new AggregateProjectReduceRule(AggregateProjectReduceRule.operand(LogicalAggregate.class, null, Aggregate.IS_SIMPLE, AggregateProjectReduceRule.operand(LogicalProject.class, AggregateProjectReduceRule.any()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "AggregateProjectReduceRule");

    private AggregateProjectReduceRule(RelOptRuleOperand operand, RelBuilderFactory factory, String description) {
        super(operand, factory, description);
    }

    private void mappingKeys(int key, Pair<RexNode, String> project, List<Pair<RexNode, String>> projects, Map<Integer, Integer> mapping) {
        if (!projects.contains(project)) {
            projects.add(project);
        }
        mapping.put(key, projects.indexOf(project));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        List<Pair<RexNode, String>> projects = project.getNamedProjects();
        ArrayList<Pair<RexNode, String>> newProjects = new ArrayList<Pair<RexNode, String>>();
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        for (int key : aggr.getGroupSet()) {
            this.mappingKeys(key, projects.get(key), newProjects, mapping);
        }
        ImmutableBitSet newGroupSet = aggr.getGroupSet().permute(mapping);
        ImmutableList.Builder newAggrCalls = ImmutableList.builder();
        for (AggregateCall aggrCall : aggr.getAggCallList()) {
            int newFilterArg;
            ImmutableList.Builder newArgs = ImmutableList.builder();
            for (int key : aggrCall.getArgList()) {
                this.mappingKeys(key, projects.get(key), newProjects, mapping);
                newArgs.add(mapping.get(key));
            }
            if (aggrCall.filterArg > 0) {
                int key;
                key = aggrCall.filterArg;
                this.mappingKeys(key, projects.get(key), newProjects, mapping);
                newFilterArg = (Integer)mapping.get(aggrCall.filterArg);
            } else {
                newFilterArg = -1;
            }
            newAggrCalls.add(aggrCall.copy((List<Integer>)((Object)newArgs.build()), newFilterArg));
        }
        if (newProjects.equals(project.getNamedProjects())) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(project.getInput());
        relBuilder.project(Pair.left(newProjects), Pair.right(newProjects));
        relBuilder.aggregate(relBuilder.groupKey(newGroupSet, false, (ImmutableList<ImmutableBitSet>)null), (List<AggregateCall>)((Object)newAggrCalls.build()));
        RelNode rel = relBuilder.build();
        call.transformTo(rel);
    }
}

