/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.source.hive.MRHiveDictUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFlatHiveTableByLivyStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CreateFlatHiveTableByLivyStep.class);
    protected final PatternedLogger stepLogger = new PatternedLogger(logger);

    protected void createFlatHiveTable(KylinConfig config) throws Exception {
        ImmutableList<String> sqls = ImmutableList.of(this.getInitStatement(), this.getCreateTableStatement());
        ExecutableManager executableManager = this.getManager();
        String jobId = this.getId();
        MRHiveDictUtil.runLivySqlJob(this.stepLogger, config, sqls, executableManager, jobId);
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        this.stepLogger.setILogListener((infoKey, info) -> {
            if ("yarn_application_id".equals(infoKey) || "yarn_application_tracking_url".equals(infoKey)) {
                this.getManager().addJobInfo(this.getId(), info);
            }
        });
        KylinConfig config = this.getCubeSpecificConfig();
        try {
            this.createFlatHiveTable(config);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), e);
        }
    }

    public void setInitStatement(String sql) {
        this.setParam("HiveInit", sql);
    }

    public String getInitStatement() {
        return this.getParam("HiveInit");
    }

    public void setCreateTableStatement(String sql) {
        this.setParam("HiveRedistributeData", sql);
    }

    public String getCreateTableStatement() {
        return this.getParam("HiveRedistributeData");
    }
}

