/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.apache.kylin.source.jdbc.metadata.IJdbcMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJdbcMetadata
implements IJdbcMetadata {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJdbcMetadata.class);
    protected DBConnConf dbconf;

    public DefaultJdbcMetadata(DBConnConf dbConnConf) {
        this.dbconf = dbConnConf;
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection con = SqlUtil.getConnection(this.dbconf);
             ResultSet rs = con.getMetaData().getSchemas();){
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                String catalog = rs.getString("TABLE_CATALOG");
                logger.info(String.format(Locale.ROOT, "%s,%s", schema, catalog));
                ret.add(schema);
            }
        }
        return ret;
    }

    @Override
    public List<String> listTables(String schema) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection con = SqlUtil.getConnection(this.dbconf);
             ResultSet rs = con.getMetaData().getTables(null, schema, null, null);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                ret.add(name);
            }
        }
        return ret;
    }

    @Override
    public ResultSet getTable(DatabaseMetaData dbmd, String schema, String table) throws SQLException {
        return dbmd.getTables(null, schema, table, null);
    }

    @Override
    public ResultSet listColumns(DatabaseMetaData dbmd, String schema, String table) throws SQLException {
        return dbmd.getColumns(null, schema, table, null);
    }

    @Override
    public SourceDialect getDialect() {
        return SourceDialect.UNKNOWN;
    }
}

