/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.dict.BuiltInFunctionTransformer;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.CubeScanRangePlanner;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryBase;
import org.apache.kylin.storage.gtrecord.ScannerWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeSegmentScanner
implements Iterable<GTRecord> {
    private static final Logger logger = LoggerFactory.getLogger(CubeSegmentScanner.class);
    final CubeSegment cubeSeg;
    final ScannerWorker scanner;
    final Cuboid cuboid;
    final GTScanRequest scanRequest;

    public CubeSegmentScanner(CubeSegment cubeSeg, Cuboid cuboid, Set<TblColRef> dimensions, Set<TblColRef> groups, List<TblColRef> dynGroups, List<TupleExpression> dynGroupExprs, Collection<FunctionDesc> metrics, List<DynamicFunctionDesc> dynFuncs, TupleFilter originalfilter, TupleFilter havingFilter, StorageContext context) {
        CubeScanRangePlanner scanRangePlanner;
        logger.info("Init CubeSegmentScanner for segment {}", (Object)cubeSeg.getName());
        this.cuboid = cuboid;
        this.cubeSeg = cubeSeg;
        byte[] serialize = TupleFilterSerializer.serialize(originalfilter, StringCodeSystem.INSTANCE);
        TupleFilter filter = TupleFilterSerializer.deserialize(serialize, StringCodeSystem.INSTANCE);
        BuiltInFunctionTransformer translator = new BuiltInFunctionTransformer(cubeSeg.getDimensionEncodingMap());
        filter = translator.transform(filter);
        try {
            scanRangePlanner = new CubeScanRangePlanner(cubeSeg, cuboid, filter, dimensions, groups, dynGroups, dynGroupExprs, metrics, dynFuncs, havingFilter, context);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.scanRequest = scanRangePlanner.planScanRequest();
        String gtStorage = ((GTCubeStorageQueryBase)context.getStorageQuery()).getGTStorage();
        this.scanner = new ScannerWorker(cubeSeg, cuboid, this.scanRequest, gtStorage, context);
    }

    public boolean isSegmentSkipped() {
        return this.scanner.isSegmentSkipped();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return this.scanner.iterator();
    }

    public void close() throws IOException {
        this.scanner.close();
    }

    public GTInfo getInfo() {
        return this.scanRequest == null ? null : this.scanRequest.getInfo();
    }

    public GTScanRequest getScanRequest() {
        return this.scanRequest;
    }
}

