/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.stream;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.hbase.steps.HBaseMROutput2Transition;
import org.apache.kylin.storage.stream.StreamStorageQuery;
import org.apache.kylin.storage.stream.rpc.HttpStreamDataSearchClient;
import org.apache.kylin.storage.stream.rpc.IStreamDataSearchClient;
import org.apache.kylin.storage.stream.rpc.MockedStreamDataSearchClient;

public class StreamStorage
implements IStorage {
    private volatile IStreamDataSearchClient realTimeSearchClient;

    @Override
    public IStorageQuery createQuery(IRealization realization) {
        if (realization.getType() == RealizationType.CUBE) {
            CubeInstance cubeInstance = (CubeInstance)realization;
            return new StreamStorageQuery(cubeInstance, this.getStreamingDataSearchClient());
        }
        throw new IllegalArgumentException("Unknown realization type " + (Object)((Object)realization.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStreamDataSearchClient getStreamingDataSearchClient() {
        if (this.realTimeSearchClient == null) {
            StreamStorage streamStorage = this;
            synchronized (streamStorage) {
                if (this.realTimeSearchClient == null) {
                    KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
                    this.realTimeSearchClient = kylinConfig.isStreamingStandAloneMode() ? new MockedStreamDataSearchClient() : new HttpStreamDataSearchClient();
                }
            }
        }
        return this.realTimeSearchClient;
    }

    @Override
    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMROutput2.class) {
            return (I)new HBaseMROutput2Transition();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }
}

