/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.assign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.StreamingCubeInfo;
import org.apache.kylin.stream.coordinator.assign.Assigner;
import org.apache.kylin.stream.coordinator.assign.AssignmentUtil;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.source.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssigner
implements Assigner {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAssigner.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<Integer, Map<String, List<Partition>>> reBalancePlan(List<ReplicaSet> replicaSets, List<StreamingCubeInfo> cubes, List<CubeAssignment> existingAssignments) {
        void var8_11;
        HashMap<Integer, Map<String, List<Partition>>> newPlan = Maps.newHashMap();
        if (replicaSets == null || cubes == null || cubes.size() == 0 || replicaSets.size() == 0) {
            return newPlan;
        }
        Map<Integer, Map<String, List<Partition>>> existingRSAssignmentsMap = AssignmentUtil.convertCubeAssign2ReplicaSetAssign(existingAssignments);
        HashMap<String, CubeAssignment> cubeAssignmentMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : existingAssignments) {
            cubeAssignmentMap.put(cubeAssignment.getCubeName(), cubeAssignment);
        }
        HashSet<Integer> currReplicaSetIDs = Sets.newHashSet();
        for (ReplicaSet replicaSet : replicaSets) {
            currReplicaSetIDs.add(replicaSet.getReplicaSetID());
        }
        boolean bl = false;
        HashMap<String, List<List<Partition>>> requireReassignTaskMap = Maps.newHashMap();
        HashSet<String> partitionChangeCubes = Sets.newHashSet();
        for (StreamingCubeInfo cube : cubes) {
            int currPartitionNum;
            CubeAssignment cubeAssignment = (CubeAssignment)cubeAssignmentMap.get(cube.getCubeName());
            int prevPartitionNum = cubeAssignment.getPartitionIDs().size();
            if (prevPartitionNum != (currPartitionNum = cube.getStreamingTableSourceInfo().getPartitions().size())) {
                List<List<Partition>> cubeConsumeTasks = this.splitCubeConsumeTasks(cube, replicaSets.size());
                requireReassignTaskMap.put(cube.getCubeName(), cubeConsumeTasks);
                partitionChangeCubes.add(cube.getCubeName());
            }
            var8_11 += cube.getNumOfConsumerTasks();
        }
        void avgTasks = var8_11 / replicaSets.size();
        for (Map.Entry<Integer, Map<String, List<Partition>>> entry : existingRSAssignmentsMap.entrySet()) {
            Integer rsId = entry.getKey();
            Map<String, List<Partition>> rsAssignment = entry.getValue();
            if (!currReplicaSetIDs.contains(rsId)) {
                throw new IllegalStateException("current replica sets don't contain rs:" + rsId);
            }
            HashMap<String, List<Partition>> newRsTaskMap = (HashMap<String, List<Partition>>)newPlan.get(rsId);
            if (newRsTaskMap == null) {
                newRsTaskMap = Maps.newHashMap();
                newPlan.put(rsId, newRsTaskMap);
            }
            for (Map.Entry<String, List<Partition>> taskEntry : rsAssignment.entrySet()) {
                String cubeName = taskEntry.getKey();
                List<Partition> partitions = taskEntry.getValue();
                if (partitionChangeCubes.contains(cubeName)) continue;
                if (newRsTaskMap.size() < avgTasks) {
                    newRsTaskMap.put(cubeName, partitions);
                    continue;
                }
                ArrayList<List<Partition>> cubeTasks = (ArrayList<List<Partition>>)requireReassignTaskMap.get(cubeName);
                if (cubeTasks == null) {
                    cubeTasks = Lists.newArrayList();
                    requireReassignTaskMap.put(cubeName, cubeTasks);
                }
                cubeTasks.add(partitions);
            }
        }
        for (Map.Entry<Integer, Map<String, List<Partition>>> entry : requireReassignTaskMap.entrySet()) {
            this.setNewPlanForCube((String)((Object)entry.getKey()), (List)((Object)entry.getValue()), replicaSets, newPlan);
        }
        return newPlan;
    }

    private void setNewPlanForCube(String cubeName, List<List<Partition>> tasks, List<ReplicaSet> replicaSets, final Map<Integer, Map<String, List<Partition>>> newPlan) {
        Collections.sort(replicaSets, new Comparator<ReplicaSet>(){

            @Override
            public int compare(ReplicaSet o1, ReplicaSet o2) {
                Map rs1Assign = (Map)newPlan.get(o1.getReplicaSetID());
                Map rs2Assign = (Map)newPlan.get(o2.getReplicaSetID());
                int taskNum1 = rs1Assign == null ? 0 : rs1Assign.size();
                int taskNum2 = rs2Assign == null ? 0 : rs2Assign.size();
                return taskNum1 - taskNum2;
            }
        });
        for (int i = 0; i < tasks.size(); ++i) {
            List<Partition> task = tasks.get(i);
            int rsId = replicaSets.get(i).getReplicaSetID();
            Map<String, List<Partition>> cubeTaskMap = newPlan.get(rsId);
            if (cubeTaskMap == null) {
                cubeTaskMap = Maps.newHashMap();
                newPlan.put(rsId, cubeTaskMap);
            }
            cubeTaskMap.put(cubeName, task);
        }
    }

    @Override
    public CubeAssignment assign(StreamingCubeInfo cube, List<ReplicaSet> replicaSets, List<CubeAssignment> existingAssignments) {
        final HashMap<Integer, Integer> replicaSetTaskNumMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : existingAssignments) {
            Set<Integer> rsIds = cubeAssignment.getReplicaSetIDs();
            for (Integer rsId : rsIds) {
                Integer taskNum = (Integer)replicaSetTaskNumMap.get(rsId);
                taskNum = taskNum != null ? Integer.valueOf(taskNum + 1) : Integer.valueOf(1);
                replicaSetTaskNumMap.put(rsId, taskNum);
            }
        }
        Collections.sort(replicaSets, new Comparator<ReplicaSet>(){

            @Override
            public int compare(ReplicaSet o1, ReplicaSet o2) {
                Integer value1 = (Integer)replicaSetTaskNumMap.get(o1.getReplicaSetID());
                Integer value2 = (Integer)replicaSetTaskNumMap.get(o2.getReplicaSetID());
                int taskNum1 = value1 == null ? 0 : value1;
                int taskNum2 = value2 == null ? 0 : value2;
                return taskNum1 - taskNum2;
            }
        });
        List<List<Partition>> taskPartitions = this.splitCubeConsumeTasks(cube, replicaSets.size());
        HashMap<Integer, List<Partition>> assignment = Maps.newHashMap();
        for (int i = 0; i < taskPartitions.size(); ++i) {
            assignment.put(replicaSets.get(i).getReplicaSetID(), taskPartitions.get(i));
        }
        CubeAssignment cubeAssignment = new CubeAssignment(cube.getCubeName(), assignment);
        return cubeAssignment;
    }

    private int getCubeConsumerTasks(StreamingCubeInfo cube, int replicaSetNum) {
        int cubeConsumerTaskNum = cube.getNumOfConsumerTasks();
        if (cubeConsumerTaskNum <= 0) {
            cubeConsumerTaskNum = 1;
        }
        List<Partition> partitionsOfCube = cube.getStreamingTableSourceInfo().getPartitions();
        if (cubeConsumerTaskNum > replicaSetNum) {
            cubeConsumerTaskNum = replicaSetNum;
        }
        if (cubeConsumerTaskNum > partitionsOfCube.size()) {
            cubeConsumerTaskNum = partitionsOfCube.size();
        }
        return cubeConsumerTaskNum;
    }

    private List<List<Partition>> splitCubeConsumeTasks(StreamingCubeInfo cube, int replicaSetNum) {
        int i;
        List<Partition> partitionsOfCube = cube.getStreamingTableSourceInfo().getPartitions();
        int cubeConsumerTaskNum = this.getCubeConsumerTasks(cube, replicaSetNum);
        int partitionsPerReceiver = partitionsOfCube.size() / cubeConsumerTaskNum;
        if (partitionsPerReceiver > 3 && replicaSetNum > cubeConsumerTaskNum) {
            logger.info("You may consider improve `kylin.stream.cube-num-of-consumer-tasks` because you still some quta left.");
        }
        ArrayList<List<Partition>> result = Lists.newArrayListWithCapacity(cubeConsumerTaskNum);
        for (i = 0; i < cubeConsumerTaskNum; ++i) {
            result.add(Lists.newArrayList());
        }
        for (i = 0; i < partitionsOfCube.size(); ++i) {
            ((List)result.get(i % cubeConsumerTaskNum)).add(partitionsOfCube.get(i));
        }
        return result;
    }
}

