/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model;

import java.util.Map;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Node {
    @JsonProperty(value="host")
    private String host;
    @JsonProperty(value="port")
    private int port;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    @JsonCreator
    public Node(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        CliCommandExecutor.checkHostName(host);
        this.host = host;
        this.port = port;
    }

    public Node() {
    }

    public static Node from(String nodeString) {
        return Node.from(nodeString, ":");
    }

    public static Node fromNormalizeString(String nodeString) {
        return Node.from(nodeString, "_");
    }

    public static Node from(String nodeString, String separateStr) {
        int lastIdx = nodeString.lastIndexOf(separateStr);
        if (lastIdx == -1) {
            throw new IllegalArgumentException("illegal host port string:" + nodeString);
        }
        String host = nodeString.substring(0, lastIdx);
        int port = Integer.parseInt(nodeString.substring(lastIdx + separateStr.length()));
        return new Node(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public String toNormalizeString() {
        return this.host + "_" + this.port;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (this.port != node.port) {
            return false;
        }
        return this.host != null ? this.host.equals(node.host) : node.host == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

