/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.stream.core.query.ResponseResultSchema;

public class HavingFilterChecker {
    final HavingFilterTuple tuple = new HavingFilterTuple();
    final IFilterCodeSystem cs = new HavingFilterCodeSys();
    private TupleFilter havingFilter;
    private ResponseResultSchema schema;

    public HavingFilterChecker(TupleFilter havingFilter, ResponseResultSchema schema) {
        this.havingFilter = havingFilter;
        this.schema = schema;
    }

    public boolean check(MeasureAggregator[] aggregators) {
        this.tuple.aggrValues = aggregators;
        return this.havingFilter.evaluate(this.tuple, this.cs);
    }

    private class HavingFilterTuple
    implements ITuple {
        MeasureAggregator[] aggrValues;

        private HavingFilterTuple() {
        }

        @Override
        public Object getValue(TblColRef col) {
            return this.aggrValues[HavingFilterChecker.this.schema.getIndexOfMetrics(col)].getState();
        }

        @Override
        public List<String> getAllFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TblColRef> getAllColumns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getAllValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITuple makeCopy() {
            throw new UnsupportedOperationException();
        }
    }

    private class HavingFilterCodeSys
    implements IFilterCodeSystem {
        Object o2Cache;
        double n2Cache;

        private HavingFilterCodeSys() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            double n2;
            double n1;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Number) {
                n1 = ((Number)o1).doubleValue();
            } else if (o1 instanceof HLLCounter) {
                n1 = ((HLLCounter)o1).getCountEstimate();
            } else if (o1 instanceof BitmapCounter) {
                n1 = ((BitmapCounter)o1).getCount();
            } else if (o1 instanceof PercentileCounter) {
                n1 = ((PercentileCounter)o1).getResultEstimate();
            } else {
                throw new RuntimeException("Unknown datatype: value=" + o1 + ", class=" + o1.getClass());
            }
            double d = n2 = this.o2Cache == o2 ? this.n2Cache : Double.parseDouble((String)o2);
            if (this.o2Cache == null) {
                this.o2Cache = o2;
                this.n2Cache = n2;
            }
            return Double.compare(n1, n2);
        }

        public boolean isNull(Object code) {
            return code == null;
        }

        public void serialize(Object code, ByteBuffer buf) {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(ByteBuffer buf) {
            throw new UnsupportedOperationException();
        }
    }
}

