/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.topn.TopNAggregator;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.query.IStreamingGTSearcher;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.StreamingBuiltInFunctionTransformer;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.query.StreamingSearchContext;
import org.apache.kylin.stream.core.storage.Record;
import org.apache.kylin.stream.core.storage.columnar.ParsedStreamingCubeInfo;
import org.apache.kylin.stream.core.storage.columnar.StringArrayComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemoryStore
implements IStreamingGTSearcher {
    private static Logger logger = LoggerFactory.getLogger(SegmentMemoryStore.class);
    protected final ParsedStreamingCubeInfo parsedStreamingCubeInfo;
    protected final String segmentName;
    private volatile Map<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>> cuboidsAggBufMap;
    private volatile ConcurrentMap<String[], MeasureAggregator[]> basicCuboidAggBufMap;
    private volatile AtomicInteger rowCount = new AtomicInteger();
    private volatile AtomicInteger originRowCount = new AtomicInteger();
    private long minEventTime = Long.MAX_VALUE;
    private long maxEventTime = 0L;
    private Map<TblColRef, Dictionary<String>> dictionaryMap;

    public void setDictionaryMap(Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.dictionaryMap = dictionaryMap;
    }

    public SegmentMemoryStore(ParsedStreamingCubeInfo parsedStreamingCubeInfo, String segmentName) {
        this.parsedStreamingCubeInfo = parsedStreamingCubeInfo;
        this.segmentName = segmentName;
        this.basicCuboidAggBufMap = new ConcurrentSkipListMap<String[], MeasureAggregator[]>(StringArrayComparator.INSTANCE);
        List<ParsedStreamingCubeInfo.CuboidInfo> additionalCuboids = parsedStreamingCubeInfo.getAdditionalCuboidsToBuild();
        if (additionalCuboids != null && !additionalCuboids.isEmpty()) {
            this.cuboidsAggBufMap = new ConcurrentHashMap<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>>(additionalCuboids.size());
            for (ParsedStreamingCubeInfo.CuboidInfo cuboidInfo : additionalCuboids) {
                this.cuboidsAggBufMap.put(cuboidInfo, new ConcurrentSkipListMap(StringArrayComparator.INSTANCE));
            }
        }
    }

    public int index(StreamingMessage event) {
        long eventTime = event.getTimestamp();
        if (eventTime < this.minEventTime) {
            this.minEventTime = eventTime;
        }
        if (eventTime > this.maxEventTime) {
            this.maxEventTime = eventTime;
        }
        List<String> row = event.getData();
        this.parsedStreamingCubeInfo.resetAggrs();
        String[] basicCuboidDimensions = this.buildBasicCuboidKey(row);
        Object[] metricsValues = this.buildValue(row);
        this.aggregate(this.basicCuboidAggBufMap, basicCuboidDimensions, metricsValues);
        if (this.cuboidsAggBufMap != null) {
            for (Map.Entry<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>> cuboidAggEntry : this.cuboidsAggBufMap.entrySet()) {
                ParsedStreamingCubeInfo.CuboidInfo cuboidInfo = cuboidAggEntry.getKey();
                ConcurrentMap<String[], MeasureAggregator[]> cuboidAggMap = cuboidAggEntry.getValue();
                String[] cuboidDimensions = this.buildCuboidKey(cuboidInfo, row);
                this.aggregate(cuboidAggMap, cuboidDimensions, metricsValues);
            }
        }
        this.originRowCount.incrementAndGet();
        return this.rowCount.get();
    }

    protected String[] buildBasicCuboidKey(List<String> row) {
        String[] key = new String[this.parsedStreamingCubeInfo.dimCount];
        for (int i = 0; i < this.parsedStreamingCubeInfo.dimCount; ++i) {
            key[i] = row.get(this.parsedStreamingCubeInfo.intermediateTableDesc.getRowKeyColumnIndexes()[i]);
        }
        return key;
    }

    protected String[] buildCuboidKey(ParsedStreamingCubeInfo.CuboidInfo cuboidInfo, List<String> row) {
        int[] columnsIndex = cuboidInfo.getColumnsIndex();
        String[] key = new String[columnsIndex.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = row.get(columnsIndex[i]);
        }
        return key;
    }

    protected Object[] buildValue(List<String> row) {
        Object[] values = new Object[this.parsedStreamingCubeInfo.measureDescs.length];
        for (int i = 0; i < this.parsedStreamingCubeInfo.measureDescs.length; ++i) {
            values[i] = this.buildValueOf(i, row);
        }
        return values;
    }

    private Object buildValueOf(int idxOfMeasure, List<String> row) {
        MeasureDesc measure = this.parsedStreamingCubeInfo.measureDescs[idxOfMeasure];
        FunctionDesc function = measure.getFunction();
        int[] colIdxOnFlatTable = this.parsedStreamingCubeInfo.intermediateTableDesc.getMeasureColumnIndexes()[idxOfMeasure];
        int paramCount = function.getParameterCount();
        String[] inputToMeasure = new String[paramCount];
        ParameterDesc param = function.getParameter();
        int paramColIdx = 0;
        int i = 0;
        while (i < paramCount) {
            String value = function.isCount() ? "1" : (param.isColumnType() ? row.get(colIdxOnFlatTable[paramColIdx++]) : param.getValue());
            inputToMeasure[i] = value;
            ++i;
            param = param.getNextParameter();
        }
        return this.parsedStreamingCubeInfo.measureIngesters[idxOfMeasure].valueOf(inputToMeasure, measure, this.dictionaryMap);
    }

    private void aggregate(ConcurrentMap<String[], MeasureAggregator[]> cuboidAggBufMap, String[] dimensions, Object[] metricsValues) {
        MeasureAggregator[] aggrs = (MeasureAggregator[])cuboidAggBufMap.get(dimensions);
        if (aggrs != null) {
            this.aggregateValues(aggrs, metricsValues);
        }
        if (aggrs == null) {
            MeasureAggregator[] newAggrs = this.newMetricsAggregators(this.parsedStreamingCubeInfo.metricsAggrFuncs);
            this.aggregateValues(newAggrs, metricsValues);
            aggrs = cuboidAggBufMap.putIfAbsent(dimensions, newAggrs);
            if (aggrs == null) {
                this.rowCount.incrementAndGet();
            } else {
                this.aggregateValues(aggrs, metricsValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggregateValues(MeasureAggregator[] aggrs, Object[] metricsValues) {
        for (int i = 0; i < aggrs.length; ++i) {
            MeasureAggregator measureAggregator = aggrs[i];
            synchronized (measureAggregator) {
                aggrs[i].aggregate(metricsValues[i]);
                continue;
            }
        }
    }

    private MeasureAggregator<?>[] newMetricsAggregators(String[] aggrFunctions) {
        MeasureAggregator[] result = new MeasureAggregator[aggrFunctions.length];
        for (int i = 0; i < result.length; ++i) {
            int col = this.parsedStreamingCubeInfo.dimCount + i;
            result[i] = MeasureAggregator.create(aggrFunctions[i], this.parsedStreamingCubeInfo.getAllDataTypes()[col]);
        }
        return result;
    }

    public int getRowCount() {
        return this.rowCount.get();
    }

    public int getOriginRowCount() {
        return this.originRowCount.get();
    }

    public ConcurrentMap<String[], MeasureAggregator[]> getBasicCuboidData() {
        return this.basicCuboidAggBufMap;
    }

    public Map<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>> getAdditionalCuboidsData() {
        return this.cuboidsAggBufMap;
    }

    public ConcurrentMap<String[], MeasureAggregator[]> getCuboidData(long cuboidID) {
        if (cuboidID == this.parsedStreamingCubeInfo.basicCuboid.getId()) {
            return this.basicCuboidAggBufMap;
        }
        ParsedStreamingCubeInfo.CuboidInfo cuboidInfo = new ParsedStreamingCubeInfo.CuboidInfo(cuboidID);
        ConcurrentMap<String[], MeasureAggregator[]> result = this.cuboidsAggBufMap.get(cuboidInfo);
        if (result != null) {
            return result;
        }
        logger.warn("no in memory cuboid data find for cuboid:{}", (Object)cuboidID);
        return this.basicCuboidAggBufMap;
    }

    public long getMinEventTime() {
        return this.minEventTime;
    }

    public long getMaxEventTime() {
        return this.maxEventTime;
    }

    @Override
    public void search(StreamingSearchContext searchContext, ResultCollector collector) throws IOException {
        ResponseResultSchema schema = searchContext.getRespResultSchema();
        TblColRef[] selectedDimensions = schema.getDimensions();
        FunctionDesc[] selectedMetrics = schema.getMetrics();
        collector.collectSearchResult(new AggregationBufferSearchResult(searchContext, selectedDimensions, selectedMetrics));
    }

    private class AggregationBufferSearchResult
    implements IStreamingSearchResult {
        private Map<String[], MeasureAggregator[]> aggBufMap;
        private int[] dimIndexes;
        private int[] metricsIndexes;
        private Map<TblColRef, Integer> dimColIdxMap;
        private TupleFilter filter;
        private int count = 0;
        private long scanCnt = 0L;
        private long filterCnt = 0L;
        private StreamingQueryProfile queryProfile;

        public AggregationBufferSearchResult(StreamingSearchContext searchRequest, TblColRef[] selectedDimensions, FunctionDesc[] selectedMetrics) {
            long hitCuboid = searchRequest.getHitCuboid();
            this.filter = searchRequest.getFilter();
            this.aggBufMap = SegmentMemoryStore.this.getCuboidData(hitCuboid);
            this.dimIndexes = new int[selectedDimensions.length];
            this.metricsIndexes = new int[selectedMetrics.length];
            this.dimColIdxMap = Maps.newHashMap();
            ParsedStreamingCubeInfo.CuboidInfo cuboidInfo = SegmentMemoryStore.this.parsedStreamingCubeInfo.getCuboidInfo(hitCuboid);
            int idx = 0;
            for (TblColRef tblColRef : selectedDimensions) {
                int dimIdx;
                this.dimIndexes[idx] = dimIdx = cuboidInfo.getIndexOf(tblColRef);
                this.dimColIdxMap.put(tblColRef, dimIdx);
                ++idx;
            }
            idx = 0;
            for (Serializable serializable : selectedMetrics) {
                this.metricsIndexes[idx] = SegmentMemoryStore.this.parsedStreamingCubeInfo.getMetricIndexInAllMetrics((FunctionDesc)serializable);
                ++idx;
            }
            this.queryProfile = StreamingQueryProfile.get();
            if (this.filter != null && this.aggBufMap != null && !this.aggBufMap.isEmpty()) {
                byte[] bytes = TupleFilterSerializer.serialize(this.filter, null, StringCodeSystem.INSTANCE);
                this.filter = TupleFilterSerializer.deserialize(bytes, StringCodeSystem.INSTANCE);
                HashSet<TblColRef> unEvaluableColumns = Sets.newHashSet();
                this.filter = new StreamingBuiltInFunctionTransformer(unEvaluableColumns).transform(this.filter);
                if (!unEvaluableColumns.isEmpty()) {
                    searchRequest.addNewGroups(unEvaluableColumns);
                }
            }
        }

        @Override
        public Iterator<Record> iterator() {
            if (this.aggBufMap == null || this.aggBufMap.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new Iterator<Record>(){
                Map.Entry<String[], MeasureAggregator[]> nextEntry;
                Record oneRecord;
                final IEvaluatableTuple oneTuple;
                final Iterator<Map.Entry<String[], MeasureAggregator[]>> it;
                {
                    this.oneRecord = new Record(AggregationBufferSearchResult.this.dimIndexes.length, AggregationBufferSearchResult.this.metricsIndexes.length);
                    this.oneTuple = new IEvaluatableTuple(){

                        @Override
                        public Object getValue(TblColRef col) {
                            return nextEntry.getKey()[(Integer)AggregationBufferSearchResult.this.dimColIdxMap.get(col)];
                        }
                    };
                    this.it = AggregationBufferSearchResult.this.aggBufMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    boolean result = false;
                    if (this.nextEntry != null) {
                        result = true;
                    } else {
                        while (this.it.hasNext()) {
                            this.nextEntry = this.it.next();
                            AggregationBufferSearchResult.this.scanCnt++;
                            if (AggregationBufferSearchResult.this.filter != null && !this.evaluateFilter()) {
                                AggregationBufferSearchResult.this.filterCnt++;
                                continue;
                            }
                            result = true;
                            break;
                        }
                    }
                    if (!result) {
                        this.nextEntry = null;
                    }
                    return result;
                }

                private boolean evaluateFilter() {
                    return AggregationBufferSearchResult.this.filter.evaluate(this.oneTuple, StringCodeSystem.INSTANCE);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Record next() {
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object object;
                        int i;
                        String[] allDimensions = this.nextEntry.getKey();
                        MeasureAggregator[] allMetrics = this.nextEntry.getValue();
                        String[] targetDimensions = new String[AggregationBufferSearchResult.this.dimIndexes.length];
                        MeasureAggregator[] targetMetrics = new MeasureAggregator[AggregationBufferSearchResult.this.metricsIndexes.length];
                        for (i = 0; i < targetDimensions.length; ++i) {
                            targetDimensions[i] = allDimensions[AggregationBufferSearchResult.this.dimIndexes[i]];
                        }
                        for (i = 0; i < targetMetrics.length; ++i) {
                            MeasureAggregator aggregator = allMetrics[AggregationBufferSearchResult.this.metricsIndexes[i]];
                            if (aggregator instanceof TopNAggregator) {
                                object = aggregator;
                                synchronized (object) {
                                    TopNAggregator topNAggregator = (TopNAggregator)aggregator;
                                    aggregator = topNAggregator.copy();
                                }
                            }
                            targetMetrics[i] = aggregator;
                        }
                        MeasureAggregators aggs = new MeasureAggregators(targetMetrics);
                        Object[] aggrResult = new Object[targetMetrics.length];
                        aggs.collectStates(aggrResult);
                        System.arraycopy(targetDimensions, 0, this.oneRecord.getDimensions(), 0, targetDimensions.length);
                        System.arraycopy(aggrResult, 0, this.oneRecord.getMetrics(), 0, aggrResult.length);
                        AggregationBufferSearchResult.this.count++;
                        object = this.oneRecord;
                        return object;
                    }
                    finally {
                        this.nextEntry = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void startRead() {
            if (this.queryProfile.isDetailProfileEnable()) {
                logger.info("query-{}: start to scan segment-{} memory store", (Object)this.queryProfile.getQueryId(), (Object)SegmentMemoryStore.this.segmentName);
                String stepName = this.getQueryStepName();
                this.queryProfile.startStep(stepName);
            }
        }

        @Override
        public void endRead() {
            this.queryProfile.incScanRows(this.scanCnt);
            this.queryProfile.incFilterRows(this.filterCnt);
            if (this.queryProfile.isDetailProfileEnable()) {
                String stepName = this.getQueryStepName();
                StreamingQueryProfile.ProfileStep profileStep = this.queryProfile.finishStep(stepName);
                profileStep.stepInfo("scan_count", String.valueOf(this.scanCnt)).stepInfo("filter_count", String.valueOf(this.filterCnt));
                logger.info("query-{}: segment-{} memory store scan finished, take {} ms", this.queryProfile.getQueryId(), SegmentMemoryStore.this.segmentName, profileStep.getDuration());
            }
        }

        private String getQueryStepName() {
            return String.format(Locale.ROOT, "segment-%s_mem_store_scan", SegmentMemoryStore.this.segmentName);
        }
    }
}

