/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class FSInputNoCompressedColumnReader
implements ColumnDataReader {
    private FSDataInputStream fsInputStream;
    private byte[] readBuffer;
    private int rowCount;

    public FSInputNoCompressedColumnReader(FileSystem fs, Path file, int colDataStartOffset, int colValLength, int rowCount) throws IOException {
        this.fsInputStream = fs.open(file);
        this.fsInputStream.seek((long)colDataStartOffset);
        this.rowCount = rowCount;
        this.readBuffer = new byte[colValLength];
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new NoCompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        throw new UnsupportedOperationException("not support to read row operation");
    }

    @Override
    public void close() throws IOException {
        this.fsInputStream.close();
    }

    private class NoCompressedColumnDataItr
    implements Iterator<byte[]> {
        private int readRowCount = 0;

        private NoCompressedColumnDataItr() {
        }

        @Override
        public boolean hasNext() {
            return this.readRowCount < FSInputNoCompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                FSInputNoCompressedColumnReader.this.fsInputStream.readFully(FSInputNoCompressedColumnReader.this.readBuffer);
            }
            catch (IOException e) {
                throw new NoSuchElementException("error when read data " + e.getMessage());
            }
            ++this.readRowCount;
            return FSInputNoCompressedColumnReader.this.readBuffer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

