/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService {
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);
    private int connectionTimeout;
    private int readTimeout;

    public RestService(int connectionTimeout, int readTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public String postRequest(String url, String postContent) throws IOException {
        return this.postRequest(url, postContent, this.connectionTimeout, this.readTimeout);
    }

    public String putRequest(String url) throws IOException {
        return this.putRequest(url, null);
    }

    public String putRequest(String url, String putContent) throws IOException {
        return this.putRequest(url, putContent, this.connectionTimeout, this.readTimeout);
    }

    public String getRequest(String url) throws IOException {
        return this.getRequest(url, this.connectionTimeout, this.readTimeout);
    }

    public String deleteRequest(String url) throws IOException {
        return this.deleteRequest(url, this.connectionTimeout, this.readTimeout);
    }

    public String postRequest(String url, String postContent, int connTimeout, int readTimeout) throws IOException {
        HttpPost request = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(postContent, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)requestEntity);
        return this.execRequest((HttpRequestBase)request, connTimeout, readTimeout);
    }

    public String putRequest(String url, String putContent, int connTimeout, int readTimeout) throws IOException {
        HttpPut request = new HttpPut(url);
        if (putContent != null) {
            StringEntity requestEntity = new StringEntity(putContent, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
        }
        return this.execRequest((HttpRequestBase)request, connTimeout, readTimeout);
    }

    public String getRequest(String url, int connTimeout, int readTimeout) throws IOException {
        HttpGet request = new HttpGet(url);
        return this.execRequest((HttpRequestBase)request, connTimeout, readTimeout);
    }

    public String deleteRequest(String url, int connTimeout, int readTimeout) throws IOException {
        HttpDelete request = new HttpDelete(url);
        return this.execRequest((HttpRequestBase)request, connTimeout, readTimeout);
    }

    private HttpClient getHttpClient(int connectionTimeout, int readTimeout) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        return new DefaultHttpClient((HttpParams)httpParams);
    }

    public String execRequest(HttpRequestBase request, int connectionTimeout, int readTimeout) throws IOException {
        HttpClient httpClient = this.getHttpClient(connectionTimeout, readTimeout);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            int code = response.getStatusLine().getStatusCode();
            if (logger.isTraceEnabled()) {
                String displayMessage = msg.length() > 500 ? msg.substring(0, 500) : msg;
                logger.trace("Send request: {}. And receive response[{}] which lenght is {}, and content is {}.", code, request.getRequestLine(), msg.length(), displayMessage);
            }
            if (code != 200) {
                throw new IOException("Invalid http response " + code + " when send request: " + request.getURI().toString() + "\n" + msg);
            }
            String string = msg;
            return string;
        }
        catch (IOException e) {
            logger.error("error when send http request:" + request.getURI().toString(), e);
            throw e;
        }
        finally {
            request.releaseConnection();
        }
    }
}

