/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.controller;

import org.apache.kylin.stream.core.model.HealthCheckInfo;
import org.apache.kylin.stream.core.model.stats.ReceiverCubeStats;
import org.apache.kylin.stream.core.model.stats.ReceiverStats;
import org.apache.kylin.stream.server.StreamingServer;
import org.apache.kylin.stream.server.rest.controller.BasicController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/stats"})
public class StatsController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(StatsController.class);
    private StreamingServer streamingServer = StreamingServer.getInstance();

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ReceiverStats getAllStats() {
        return this.streamingServer.getReceiverStats();
    }

    @RequestMapping(value={"/cubes/{cubeName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ReceiverCubeStats getCubeStats(@PathVariable String cubeName) {
        return this.streamingServer.getCubeStats(cubeName);
    }

    @RequestMapping(value={"/healthCheck"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public HealthCheckInfo healthCheck() {
        HealthCheckInfo result = new HealthCheckInfo();
        result.setStatus(HealthCheckInfo.Status.GOOD);
        return result;
    }
}

