/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.stream.core.exception.StreamingException;
import org.apache.kylin.stream.core.source.ISourcePosition;
import org.apache.kylin.stream.core.source.ISourcePositionHandler;
import org.apache.kylin.stream.source.kafka.KafkaPosition;

public class KafkaPositionHandler
implements ISourcePositionHandler {
    @Override
    public ISourcePosition mergePositions(Collection<ISourcePosition> positions, ISourcePositionHandler.MergeStrategy mergeStrategy) {
        KafkaPosition result = new KafkaPosition();
        for (ISourcePosition position : positions) {
            KafkaPosition kafkaPosition = (KafkaPosition)position;
            Map<Integer, Long> partitionOffsetMap = kafkaPosition.getPartitionOffsets();
            for (Map.Entry<Integer, Long> partOffsetEntry : partitionOffsetMap.entrySet()) {
                Long existPartOffset = result.getPartitionOffsets().get(partOffsetEntry.getKey());
                if (existPartOffset == null) {
                    result.getPartitionOffsets().put(partOffsetEntry.getKey(), partOffsetEntry.getValue());
                    continue;
                }
                int compResult = partOffsetEntry.getValue().compareTo(existPartOffset);
                if (!(mergeStrategy == ISourcePositionHandler.MergeStrategy.KEEP_LARGE && compResult > 0 || mergeStrategy == ISourcePositionHandler.MergeStrategy.KEEP_SMALL && compResult < 0) && mergeStrategy != ISourcePositionHandler.MergeStrategy.KEEP_LATEST) continue;
                result.getPartitionOffsets().put(partOffsetEntry.getKey(), partOffsetEntry.getValue());
            }
        }
        return result;
    }

    @Override
    public ISourcePosition createEmptyPosition() {
        return new KafkaPosition();
    }

    @Override
    public ISourcePosition parsePosition(String positionStr) {
        try {
            Map<Integer, Long> partitionOffsetMap = JsonUtil.readValue(positionStr, new TypeReference<Map<Integer, Long>>(){});
            return new KafkaPosition(partitionOffsetMap);
        }
        catch (IOException e) {
            throw new StreamingException(e);
        }
    }

    @Override
    public String serializePosition(ISourcePosition position) {
        try {
            KafkaPosition kafkaPosition = (KafkaPosition)position;
            return JsonUtil.writeValueAsString(kafkaPosition.getPartitionOffsets());
        }
        catch (JsonProcessingException e) {
            throw new StreamingException(e);
        }
    }
}

