/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.ContextCacheUtils;
import org.springframework.util.Assert;

public class DefaultContextCache
implements ContextCache {
    private static final Log statsLogger = LogFactory.getLog("org.springframework.test.context.cache");
    private final Map<MergedContextConfiguration, ApplicationContext> contextMap = Collections.synchronizedMap(new LruCache(32, 0.75f));
    private final Map<MergedContextConfiguration, Set<MergedContextConfiguration>> hierarchyMap = new ConcurrentHashMap<MergedContextConfiguration, Set<MergedContextConfiguration>>(32);
    private final int maxSize;
    private final AtomicInteger hitCount = new AtomicInteger();
    private final AtomicInteger missCount = new AtomicInteger();

    public DefaultContextCache() {
        this(ContextCacheUtils.retrieveMaxCacheSize());
    }

    public DefaultContextCache(int maxSize) {
        Assert.isTrue(maxSize > 0, "'maxSize' must be positive");
        this.maxSize = maxSize;
    }

    @Override
    public boolean contains(MergedContextConfiguration key) {
        Assert.notNull(key, "Key must not be null");
        return this.contextMap.containsKey(key);
    }

    @Override
    public ApplicationContext get(MergedContextConfiguration key) {
        Assert.notNull(key, "Key must not be null");
        ApplicationContext context = this.contextMap.get(key);
        if (context == null) {
            this.missCount.incrementAndGet();
        } else {
            this.hitCount.incrementAndGet();
        }
        return context;
    }

    @Override
    public void put(MergedContextConfiguration key, ApplicationContext context) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(context, "ApplicationContext must not be null");
        this.contextMap.put(key, context);
        MergedContextConfiguration child = key;
        MergedContextConfiguration parent = child.getParent();
        while (parent != null) {
            Set<MergedContextConfiguration> list = this.hierarchyMap.get(parent);
            if (list == null) {
                list = new HashSet<MergedContextConfiguration>();
                this.hierarchyMap.put(parent, list);
            }
            list.add(child);
            child = parent;
            parent = child.getParent();
        }
    }

    @Override
    public void remove(MergedContextConfiguration key, DirtiesContext.HierarchyMode hierarchyMode) {
        Assert.notNull(key, "Key must not be null");
        MergedContextConfiguration startKey = key;
        if (hierarchyMode == DirtiesContext.HierarchyMode.EXHAUSTIVE) {
            while (startKey.getParent() != null) {
                startKey = startKey.getParent();
            }
        }
        ArrayList<MergedContextConfiguration> removedContexts = new ArrayList<MergedContextConfiguration>();
        this.remove(removedContexts, startKey);
        for (MergedContextConfiguration currentKey : removedContexts) {
            for (Set<MergedContextConfiguration> children : this.hierarchyMap.values()) {
                children.remove(currentKey);
            }
        }
        for (MergedContextConfiguration currentKey : this.hierarchyMap.keySet()) {
            if (!this.hierarchyMap.get(currentKey).isEmpty()) continue;
            this.hierarchyMap.remove(currentKey);
        }
    }

    private void remove(List<MergedContextConfiguration> removedContexts, MergedContextConfiguration key) {
        ApplicationContext context;
        Assert.notNull(key, "Key must not be null");
        Set<MergedContextConfiguration> children = this.hierarchyMap.get(key);
        if (children != null) {
            for (MergedContextConfiguration child : children) {
                this.remove(removedContexts, child);
            }
            this.hierarchyMap.remove(key);
        }
        if ((context = this.contextMap.remove(key)) instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).close();
        }
        removedContexts.add(key);
    }

    @Override
    public int size() {
        return this.contextMap.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getParentContextCount() {
        return this.hierarchyMap.size();
    }

    @Override
    public int getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public int getMissCount() {
        return this.missCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.clear();
            this.clearStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.contextMap.clear();
            this.hierarchyMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStatistics() {
        Map<MergedContextConfiguration, ApplicationContext> map = this.contextMap;
        synchronized (map) {
            this.hitCount.set(0);
            this.missCount.set(0);
        }
    }

    @Override
    public void logStatistics() {
        if (statsLogger.isDebugEnabled()) {
            statsLogger.debug("Spring test ApplicationContext cache statistics: " + this);
        }
    }

    public String toString() {
        return new ToStringCreator(this).append("size", this.size()).append("maxSize", this.getMaxSize()).append("parentContextCount", this.getParentContextCount()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).toString();
    }

    private class LruCache
    extends LinkedHashMap<MergedContextConfiguration, ApplicationContext> {
        LruCache(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<MergedContextConfiguration, ApplicationContext> eldest) {
            if (this.size() > DefaultContextCache.this.getMaxSize()) {
                DefaultContextCache.this.remove(eldest.getKey(), DirtiesContext.HierarchyMode.CURRENT_LEVEL);
            }
            return false;
        }
    }
}

