/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.rules;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.junit.ClassRule;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.rules.SpringClassRule;
import org.springframework.test.context.junit4.statements.ProfileValueChecker;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunPrepareTestInstanceCallbacks;
import org.springframework.test.context.junit4.statements.SpringFailOnTimeout;
import org.springframework.test.context.junit4.statements.SpringRepeat;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SpringMethodRule
implements MethodRule {
    private static final Log logger = LogFactory.getLog(SpringMethodRule.class);

    public Statement apply(Statement base, FrameworkMethod frameworkMethod, Object testInstance) {
        if (logger.isDebugEnabled()) {
            logger.debug("Applying SpringMethodRule to test method [" + frameworkMethod.getMethod() + "]");
        }
        Class<?> testClass = testInstance.getClass();
        SpringMethodRule.validateSpringClassRuleConfiguration(testClass);
        TestContextManager testContextManager = SpringClassRule.getTestContextManager(testClass);
        Statement statement = base;
        statement = this.withBeforeTestMethodCallbacks(statement, frameworkMethod, testInstance, testContextManager);
        statement = this.withAfterTestMethodCallbacks(statement, frameworkMethod, testInstance, testContextManager);
        statement = this.withTestInstancePreparation(statement, testInstance, testContextManager);
        statement = this.withPotentialRepeat(statement, frameworkMethod, testInstance);
        statement = this.withPotentialTimeout(statement, frameworkMethod, testInstance);
        statement = this.withProfileValueCheck(statement, frameworkMethod, testInstance);
        return statement;
    }

    private Statement withBeforeTestMethodCallbacks(Statement statement, FrameworkMethod frameworkMethod, Object testInstance, TestContextManager testContextManager) {
        return new RunBeforeTestMethodCallbacks(statement, testInstance, frameworkMethod.getMethod(), testContextManager);
    }

    private Statement withAfterTestMethodCallbacks(Statement statement, FrameworkMethod frameworkMethod, Object testInstance, TestContextManager testContextManager) {
        return new RunAfterTestMethodCallbacks(statement, testInstance, frameworkMethod.getMethod(), testContextManager);
    }

    private Statement withTestInstancePreparation(Statement statement, Object testInstance, TestContextManager testContextManager) {
        return new RunPrepareTestInstanceCallbacks(statement, testInstance, testContextManager);
    }

    private Statement withPotentialRepeat(Statement next, FrameworkMethod frameworkMethod, Object testInstance) {
        return new SpringRepeat(next, frameworkMethod.getMethod());
    }

    private Statement withPotentialTimeout(Statement next, FrameworkMethod frameworkMethod, Object testInstance) {
        return new SpringFailOnTimeout(next, frameworkMethod.getMethod());
    }

    private Statement withProfileValueCheck(Statement statement, FrameworkMethod frameworkMethod, Object testInstance) {
        return new ProfileValueChecker(statement, testInstance.getClass(), frameworkMethod.getMethod());
    }

    private static SpringClassRule validateSpringClassRuleConfiguration(Class<?> testClass) {
        AccessibleObject ruleField = null;
        for (Field field : testClass.getFields()) {
            if (!ReflectionUtils.isPublicStaticFinal(field) || !SpringClassRule.class.isAssignableFrom(field.getType())) continue;
            ruleField = field;
            break;
        }
        if (ruleField == null) {
            throw new IllegalStateException(String.format("Failed to find 'public static final SpringClassRule' field in test class [%s]. Consult the javadoc for SpringClassRule for details.", testClass.getName()));
        }
        if (!ruleField.isAnnotationPresent(ClassRule.class)) {
            throw new IllegalStateException(String.format("SpringClassRule field [%s] must be annotated with JUnit's @ClassRule annotation. Consult the javadoc for SpringClassRule for details.", ruleField));
        }
        return (SpringClassRule)ReflectionUtils.getField((Field)ruleField, null);
    }

    static {
        if (!ClassUtils.isPresent("org.junit.internal.Throwables", SpringMethodRule.class.getClassLoader())) {
            throw new IllegalStateException("SpringMethodRule requires JUnit 4.12 or higher.");
        }
    }
}

